# PLOT OF S-WAVE SCATTERING IN THE AA CHANNEL WHERE LMAX = 2
# INCLUSION OF D STATES

import matplotlib.pyplot as plt
import numpy as np
from matplotlib.ticker import (MultipleLocator, AutoMinorLocator)

from data import *

# FONT -----------------------------------------------------------------------
rc = {"font.family" : "serif", 
      "mathtext.fontset" : "stix"}
plt.rcParams.update(rc)
# ----------------------------------------------------------------------------


# PLOTS
# THREE PANNELS DETAILING THE SCATTERING LENGTH, THE BOUND STATES ON A RELATIVE 
# ENERGY LEVEL, AND THE BOUND STATES ON AN ABSOLUTE ENERGY SCALE.
# ----------------------------------------------------------------------------
fig, (ax1, ax2, ax3) = plt.subplots(3, 1,sharex=True,figsize=(6, 12),gridspec_kw={'height_ratios': [1,1,3]})
plt.subplots_adjust(hspace=0.03)
# ----------------------------------------------------------------------------





# ----------------------------------------------------------------------------
# AX1
# PLOT OF THE SCATTERING LENGTHS.
# ----------------------------------------------------------------------------
line1 = ax1.plot(field_list,y4,'-',color='red')

# ax1 parameters
ax1.set_xlim(500,1400)
ax1.set_ylim(-32,90)
ax1.set_ylabel('$a(B)$  ($\mathrm{a}_0$)',size=18,labelpad=13)
ax1.set_yticks(np.arange(0,100,50))
ax1.yaxis.set_minor_locator(MultipleLocator(25))
ax1.tick_params(axis="x",which='both',direction="in",labelsize=16)
ax1.tick_params(axis="y",which='both',direction="in",labelsize=16)
# ----------------------------------------------------------------------------





# ----------------------------------------------------------------------------
# AX2
# PLOT OF THE STATES ON A RELATIVE ENERGY SCALE.
# ----------------------------------------------------------------------------
threshold_ref = [[0,0],[1400,0]]
threshold = np.array(threshold_ref)
right_side_2 = ax2.spines["right"]
top_side_2 = ax2.spines["top"]
top_side_2.set_visible(False)

# THRESHOLD WHICH THE STATES ARE PLOTTED RELATIVE TO 
lineref2 = ax2.plot(threshold[:,0],threshold[:,1],'--',color='black',linewidth=1.5)

# BOUND STATES WITHIN 600 MHZ OF THE THRESHOLD.
# ----------------------------------------------------------------------------
# MF4 STATES
line2 = ax2.plot(field_list_312,data_list_312,color='black',linewidth=1.5)
line3 = ax2.plot(field_list_311,data_list_311,color='black',linewidth=1.5)
line4 = ax2.plot(field_list_310,data_list_310,color='black',linewidth=1.5)
line5 = ax2.plot(field_list_309,data_list_309,color='black',linewidth=1.5)
line6 = ax2.plot(field_list_308,data_list_308,color='black',linewidth=1.5)
line7 = ax2.plot(field_list_307,data_list_307,color='black',linewidth=1.5)
line8 = ax2.plot(field_list_306,data_list_306,color='black',linewidth=1.5)

# MF2 STATES
line8 = ax2.plot(field_list_603,data_list_603,color='royalblue',linewidth=0.5)
line8 = ax2.plot(field_list_602,data_list_602,color='royalblue',linewidth=0.5)
line8 = ax2.plot(field_list_601,data_list_601,color='royalblue',linewidth=0.5)
line9 = ax2.plot(field_list_600,data_list_600,color='royalblue',linewidth=0.5)
line10 = ax2.plot(field_list_599,data_list_599,color='royalblue',linewidth=0.5)
line11 = ax2.plot(field_list_598,data_list_598,color='royalblue',linewidth=0.5)
line12 = ax2.plot(field_list_597,data_list_597,color='royalblue',linewidth=0.5)
line13 = ax2.plot(field_list_596,data_list_596,color='royalblue',linewidth=0.5)
line14 = ax2.plot(field_list_595,data_list_595,color='royalblue',linewidth=0.5)
line15 = ax2.plot(field_list_594,data_list_594,color='royalblue',linewidth=0.5)
line16 = ax2.plot(field_list_593,data_list_593,color='royalblue',linewidth=0.5)
line16 = ax2.plot(field_list_592,data_list_592,color='royalblue',linewidth=0.5)
line16 = ax2.plot(field_list_591,data_list_591,color='royalblue',linewidth=0.5)
line16 = ax2.plot(field_list_590,data_list_590,color='royalblue',linewidth=0.5)
line16 = ax2.plot(field_list_589,data_list_589,color='royalblue',linewidth=0.5)
line16 = ax2.plot(field_list_588,data_list_588,color='royalblue',linewidth=0.5)
line16 = ax2.plot(field_list_587,data_list_587,color='royalblue',linewidth=0.5)

# MF3 STATES
line17 = ax2.plot(field_list_469,data_list_469,color='maroon',linewidth=0.5)
line18 = ax2.plot(field_list_468,data_list_468,color='maroon',linewidth=0.5)
line19 = ax2.plot(field_list_467,data_list_467,color='maroon',linewidth=0.5)
line20 = ax2.plot(field_list_466,data_list_466,color='maroon',linewidth=0.5)
line21 = ax2.plot(field_list_465,data_list_465,color='maroon',linewidth=0.5)
line22 = ax2.plot(field_list_464,data_list_464,color='maroon',linewidth=0.5)
line23 = ax2.plot(field_list_463,data_list_463,color='maroon',linewidth=0.5)
line24 = ax2.plot(field_list_462,data_list_462,color='maroon',linewidth=0.5)
line25 = ax2.plot(field_list_461,data_list_461,color='maroon',linewidth=0.5)
line25 = ax2.plot(field_list_460,data_list_460,color='maroon',linewidth=0.5)
line25 = ax2.plot(field_list_459,data_list_459,color='maroon',linewidth=0.5)
line25 = ax2.plot(field_list_458,data_list_458,color='maroon',linewidth=0.5)
line25 = ax2.plot(field_list_457,data_list_457,color='maroon',linewidth=0.5)

# MF4 (L=2) STATES
line29 = ax2.plot(field_list_312_4,data_list_312_4,color='green',linewidth=0.7)
line30 = ax2.plot(field_list_311_4,data_list_311_4,color='green',linewidth=0.7)
line31 = ax2.plot(field_list_310_4,data_list_310_4,color='green',linewidth=0.7)
line26 = ax2.plot(field_list_309_4,data_list_309_4,color='green',linewidth=0.7)
line27 = ax2.plot(field_list_308_4,data_list_308_4,color='green',linewidth=0.7)
line28 = ax2.plot(field_list_307_4,data_list_307_4,color='green',linewidth=0.7)
line28 = ax2.plot(field_list_306_4,data_list_306_4,color='green',linewidth=0.7)

# MF5 STATES
line29 = ax2.plot(field_list_153,data_list_153,color='darkorange',linewidth=0.5)
line29 = ax2.plot(field_list_154,data_list_154,color='darkorange',linewidth=0.5)
line29 = ax2.plot(field_list_155,data_list_155,color='darkorange',linewidth=0.5)

# MF6 STATES
line30 = ax2.plot(field_list_23,data_list_23,color='violet',linewidth=0.5)


# ax2 parameters
ax2.set_ylabel('$E/h$  (MHz)',size=18,labelpad=13)
ax2.set_xlim(000,1400)
ax2.set_ylim(-600,0)
ax2.yaxis.set_minor_locator(MultipleLocator(100))
ax2.xaxis.set_minor_locator(MultipleLocator(20))
ax2.tick_params(axis="x",which='both',direction="in",labelsize=16)
ax2.tick_params(axis="y",which='both',direction="in",labelsize=16)
# ----------------------------------------------------------------------------






# ----------------------------------------------------------------------------
# AX3 
# PLOT OF THE BOUND STATES ON AN ABSOLUTE SCALE.
# ----------------------------------------------------------------------------

# AA THRESHOLD
line_thresh = ax3.plot(field_values,energy_1_list,'--',color='black')

# MF4 STATES
line2 = ax3.plot(field_list_312,data_output_312,color='black',linewidth=1.5)
line3 = ax3.plot(field_list_311,data_output_311,color='black',linewidth=1.5)
line4 = ax3.plot(field_list_310,data_output_310,color='black',linewidth=1.5)
line5 = ax3.plot(field_list_309,data_output_309,color='black',linewidth=1.5)
line6 = ax3.plot(field_list_308,data_output_308,color='black',linewidth=1.5)
line7 = ax3.plot(field_list_307,data_output_307,color='black',linewidth=1.5)
line8 = ax3.plot(field_list_306,data_output_306,color='black',linewidth=1.5)

# MF2 STATES
line8 = ax3.plot(field_list_603,data_output_603,color='royalblue',linewidth=0.5)
line8 = ax3.plot(field_list_602,data_output_602,color='royalblue',linewidth=0.5)
line8 = ax3.plot(field_list_601,data_output_601,color='royalblue',linewidth=0.5)
line9 = ax3.plot(field_list_600,data_output_600,color='royalblue',linewidth=0.5)
line10 = ax3.plot(field_list_599,data_output_599,color='royalblue',linewidth=0.5)
line11 = ax3.plot(field_list_598,data_output_598,color='royalblue',linewidth=0.5)
line12 = ax3.plot(field_list_597,data_output_597,color='royalblue',linewidth=0.5)
line13 = ax3.plot(field_list_596,data_output_596,color='royalblue',linewidth=0.5)
line14 = ax3.plot(field_list_595,data_output_595,color='royalblue',linewidth=0.5)
line15 = ax3.plot(field_list_594,data_output_594,color='royalblue',linewidth=0.5)
line16 = ax3.plot(field_list_593,data_output_593,color='royalblue',linewidth=0.5)
line16 = ax3.plot(field_list_592,data_output_592,color='royalblue',linewidth=0.5)
line16 = ax3.plot(field_list_591,data_output_591,color='royalblue',linewidth=0.5)
line16 = ax3.plot(field_list_590,data_output_590,color='royalblue',linewidth=0.5)
line16 = ax3.plot(field_list_589,data_output_589,color='royalblue',linewidth=0.5)
line16 = ax3.plot(field_list_588,data_output_588,color='royalblue',linewidth=0.5)
line16 = ax3.plot(field_list_587,data_output_587,color='royalblue',linewidth=0.5)

# MF3 STATES
line17 = ax3.plot(field_list_469,data_output_469,color='maroon',linewidth=0.5)
line18 = ax3.plot(field_list_468,data_output_468,color='maroon',linewidth=0.5)
line19 = ax3.plot(field_list_467,data_output_467,color='maroon',linewidth=0.5)
line20 = ax3.plot(field_list_466,data_output_466,color='maroon',linewidth=0.5)
line21 = ax3.plot(field_list_465,data_output_465,color='maroon',linewidth=0.5)
line22 = ax3.plot(field_list_464,data_output_464,color='maroon',linewidth=0.5)
line23 = ax3.plot(field_list_463,data_output_463,color='maroon',linewidth=0.5)
line24 = ax3.plot(field_list_462,data_output_462,color='maroon',linewidth=0.5)
line25 = ax3.plot(field_list_461,data_output_461,color='maroon',linewidth=0.5)
line25 = ax3.plot(field_list_460,data_output_460,color='maroon',linewidth=0.5)
line25 = ax3.plot(field_list_459,data_output_459,color='maroon',linewidth=0.5)
line25 = ax3.plot(field_list_458,data_output_458,color='maroon',linewidth=0.5)
line25 = ax3.plot(field_list_457,data_output_457,color='maroon',linewidth=0.5)

# MF4 (L=2) STATES
line29 = ax3.plot(field_list_312_4,data_output_312_4,color='green',linewidth=0.7)
line30 = ax3.plot(field_list_311_4,data_output_311_4,color='green',linewidth=0.7)
line31 = ax3.plot(field_list_310_4,data_output_310_4,color='green',linewidth=0.7)
line26 = ax3.plot(field_list_309_4,data_output_309_4,color='green',linewidth=0.7)
line27 = ax3.plot(field_list_308_4,data_output_308_4,color='green',linewidth=0.7)
line28 = ax3.plot(field_list_307_4,data_output_307_4,color='green',linewidth=0.7)
line28 = ax3.plot(field_list_306_4,data_output_306_4,color='green',linewidth=0.7)

# MF5 STATES
line29 = ax3.plot(field_list_153,data_output_153,color='darkorange',linewidth=0.5)
line29 = ax3.plot(field_list_154,data_output_154,color='darkorange',linewidth=0.5)
line29 = ax3.plot(field_list_155,data_output_155,color='darkorange',linewidth=0.5)

# MF6 STATES
line30 = ax3.plot(field_list_23,data_output_23,color='violet',linewidth=0.5)

# ax3 parameters
ax3.set_ylabel('$E/h$  (MHz)',size=18,
               labelpad=10)
ax3.set_xlabel('Magnetic field  (G)',size=18,
               labelpad=10)
ax3.set_ylim(-4200,100)
ax3.set_xticks(np.arange(0,1500,200))
ax3.tick_params(axis="x",which='both',direction="in",labelsize=16)
ax3.tick_params(axis="y",which='both',direction="in",labelsize=16)
# ----------------------------------------------------------------------------


# ----------------------------------------------------------------------------
# FIGURE TEXT.
# ----------------------------------------------------------------------------
fig.text(0.7,0.54,'$L=2, M_F = 2$',color='royalblue',size=15)
fig.text(0.7,0.52,'$L=2, M_F = 3$',color='maroon',size=15)
fig.text(0.7,0.50,'$L=2, M_F = 4$',color='green',size=15)
fig.text(0.7,0.48,'$L=2, M_F = 5$',color='darkorange',size=15)
fig.text(0.7,0.46,'$L=2, M_F = 6$',color='violet',size=15)
fig.text(0.7,0.44,'$L=0, M_F = 4$',color='black',size=15)

fig.text(0.140,0.862,'(c)',size=16)
fig.text(0.128,0.706,'(b)',size=16)
fig.text(0.175,0.544,'(a)',size=16)
# ----------------------------------------------------------------------------
# ----------------------------------------------------------------------------

plt.show()
