# LOAD THE DATA
import numpy as np


# LOAD THE SCATTERING LENGTH DATA
# ----------------------------------------------------------------------------
fin = open("scattering_data.txt", "r")
field = []
data1 = []
for line in fin:
    columns = line.split()
    field.append(columns[5:6])
    data1.append(columns[11:12])
fin.close()
field_list = []
for i in field :
    for x in i :
        field_list.append(float(x))
data1_list = []
for i in data1 :
    for x in i :
        data1_list.append(float(x)/(1.0E+06))
# ----------------------------------------------------------------------------


# LOAD THE THRESHOLD ENERGIES
# ----------------------------------------------------------------------------
fin = open("aa_threshold.txt", "r")
energy_1_list = []
for line in fin:
    columns = line.split()
    energy_1_list.append(float(columns[3:4][0])-(-6278.12170297))
fin.close()

# field values every 2G
field_values = np.arange(0,1402,2).tolist()
# ----------------------------------------------------------------------------




# BOUND STATE ENERGIES
# NEED TO OUTPUT DATA IN ABSOLUTE AND RELATIVE FORMS
# EXTRACT DATA AND CONVERT 

# MF4 
# ----------------------------------------------------------------------------
field_list_312 = []
data_list_312  = []
field_list_311 = []
data_list_311  = []
field_list_310 = []
data_list_310  = []
field_list_309 = []
data_list_309  = []
field_list_308 = []
data_list_308  = []
field_list_307 = []
data_list_307  = []
field_list_306 = []
data_list_306  = []

fin = open("data_mf4.txt", "r")
for line in fin:
    columns = line.split()
    if columns[1:2] == ['312,']:
        field_list_312.append(float(columns[5:6][0]))
        data_list_312.append(float(columns[12:13][0]))
    if columns[1:2] == ['311,']:
        field_list_311.append(float(columns[5:6][0]))
        data_list_311.append(float(columns[12:13][0]))
    if columns[1:2] == ['310,']:
        field_list_310.append(float(columns[5:6][0]))
        data_list_310.append(float(columns[12:13][0]))  
    if columns[1:2] == ['309,']:
        field_list_309.append(float(columns[5:6][0]))
        data_list_309.append(float(columns[12:13][0]))  
    if columns[1:2] == ['308,']:
        field_list_308.append(float(columns[5:6][0]))
        data_list_308.append(float(columns[12:13][0]))  
    if columns[1:2] == ['307,']:
        field_list_307.append(float(columns[5:6][0]))
        data_list_307.append(float(columns[12:13][0]))
    if columns[1:2] == ['306,']:
        field_list_306.append(float(columns[5:6][0]))
        data_list_306.append(float(columns[12:13][0])) 
fin.close()


# Adjust data for plotting on an absolute scale
# At each field, add the threshold energy 
data_output_312 = []
data_output_311 = []
data_output_310 = []
data_output_309 = []
data_output_308 = []
data_output_307 = []
data_output_306 = []
for N in range(len(field_values)):
    for i in range(len(data_list_312)):
        if (field_values[N] == field_list_312[i]):
            result = data_list_312[i] + energy_1_list[N]
            data_output_312.append(result)
    for i in range(len(data_list_311)):
        if (field_values[N] == field_list_311[i]):
            result = data_list_311[i] + energy_1_list[N]
            data_output_311.append(result)
    for i in range(len(data_list_310)):
        if (field_values[N] == field_list_310[i]):
            result = data_list_310[i] + energy_1_list[N]
            data_output_310.append(result)
    for i in range(len(data_list_309)):
        if (field_values[N] == field_list_309[i]):
            result = data_list_309[i] + energy_1_list[N]
            data_output_309.append(result)
    for i in range(len(data_list_308)):
        if (field_values[N] == field_list_308[i]):
            result = data_list_308[i] + energy_1_list[N]
            data_output_308.append(result)
    for i in range(len(data_list_307)):
        if (field_values[N] == field_list_307[i]):
            result = data_list_307[i] + energy_1_list[N]
            data_output_307.append(result)
    for i in range(len(data_list_306)):
        if (field_values[N] == field_list_306[i]):
            result = data_list_306[i] + energy_1_list[N]
            data_output_306.append(result)
# ----------------------------------------------------------------------------



# MF3 
# ----------------------------------------------------------------------------
field_list_459 = []
data_list_459  = []
field_list_460 = []
data_list_460  = []
field_list_461 = []
data_list_461  = []
field_list_462 = []
data_list_462  = []
field_list_463 = []
data_list_463  = []
field_list_464 = []
data_list_464  = []
field_list_465 = []
data_list_465  = []
field_list_466 = []
data_list_466  = []
field_list_467 = []
data_list_467  = []
field_list_468 = []
data_list_468  = []
field_list_469 = []
data_list_469  = []

fin = open("data_mf3.txt", "r")
for line in fin:
    columns = line.split()
    if columns[1:2] == ['459,']:
        field_list_459.append(float(columns[5:6][0]))
        data_list_459.append(float(columns[12:13][0]))
    if columns[1:2] == ['460,']:
        field_list_460.append(float(columns[5:6][0]))
        data_list_460.append(float(columns[12:13][0]))
    if columns[1:2] == ['461,']:
        field_list_461.append(float(columns[5:6][0]))
        data_list_461.append(float(columns[12:13][0]))
    if columns[1:2] == ['462,']:
        field_list_462.append(float(columns[5:6][0]))
        data_list_462.append(float(columns[12:13][0]))
    if columns[1:2] == ['463,']:
        field_list_463.append(float(columns[5:6][0]))
        data_list_463.append(float(columns[12:13][0]))  
    if columns[1:2] == ['464,']:
        field_list_464.append(float(columns[5:6][0]))
        data_list_464.append(float(columns[12:13][0]))  
    if columns[1:2] == ['465,']:
        field_list_465.append(float(columns[5:6][0]))
        data_list_465.append(float(columns[12:13][0]))  
    if columns[1:2] == ['466,']:
        field_list_466.append(float(columns[5:6][0]))
        data_list_466.append(float(columns[12:13][0]))  
    if columns[1:2] == ['467,']:
        field_list_467.append(float(columns[5:6][0]))
        data_list_467.append(float(columns[12:13][0]))  
    if columns[1:2] == ['468,']:
        field_list_468.append(float(columns[5:6][0]))
        data_list_468.append(float(columns[12:13][0]))
    if columns[1:2] == ['469,']:
        field_list_469.append(float(columns[5:6][0]))
        data_list_469.append(float(columns[12:13][0]))  
fin.close()

   
# Adjust data for plotting on an absolute scale
# At each field, add the threshold energy 
data_output_459 = []
data_output_460 = []
data_output_461 = []
data_output_462 = []
data_output_463 = []
data_output_464 = []
data_output_465 = []
data_output_466 = []
data_output_467 = []
data_output_468 = []
data_output_469 = []
for N in range(len(field_values)):
    for i in range(len(data_list_459)):
        if (field_values[N] == field_list_459[i]):
            result = data_list_459[i] + energy_1_list[N]
            data_output_459.append(result)
    for i in range(len(data_list_460)):
        if (field_values[N] == field_list_460[i]):
            result = data_list_460[i] + energy_1_list[N]
            data_output_460.append(result)
    for i in range(len(data_list_461)):
        if (field_values[N] == field_list_461[i]):
            result = data_list_461[i] + energy_1_list[N]
            data_output_461.append(result)
    for i in range(len(data_list_462)):
        if (field_values[N] == field_list_462[i]):
            result = data_list_462[i] + energy_1_list[N]
            data_output_462.append(result)
    for i in range(len(data_list_463)):
        if (field_values[N] == field_list_463[i]):
            result = data_list_463[i] + energy_1_list[N]
            data_output_463.append(result)
    for i in range(len(data_list_464)):
        if (field_values[N] == field_list_464[i]):
            result = data_list_464[i] + energy_1_list[N]
            data_output_464.append(result)     
    for i in range(len(data_list_465)):
        if (field_values[N] == field_list_465[i]):
            result = data_list_465[i] + energy_1_list[N]
            data_output_465.append(result)
    for i in range(len(data_list_466)):
        if (field_values[N] == field_list_466[i]):
            result = data_list_466[i] + energy_1_list[N]
            data_output_466.append(result)
    for i in range(len(data_list_467)):
        if (field_values[N] == field_list_467[i]):
            result = data_list_467[i] + energy_1_list[N]
            data_output_467.append(result)
    for i in range(len(data_list_468)):
        if (field_values[N] == field_list_468[i]):
            result = data_list_468[i] + energy_1_list[N]
            data_output_468.append(result)
    for i in range(len(data_list_469)):
        if (field_values[N] == field_list_469[i]):
            result = data_list_469[i] + energy_1_list[N]
            data_output_469.append(result)
# ----------------------------------------------------------------------------




# MF5
# ----------------------------------------------------------------------------
field_list_153 = []
data_list_153  = []
field_list_154 = []
data_list_154  = []
field_list_155 = []
data_list_155  = []


fin = open("data_mf5.txt", "r")
for line in fin:
    columns = line.split()
    if columns[1:2] == ['153,']:
        field_list_153.append(float(columns[5:6][0]))
        data_list_153.append(float(columns[12:13][0]))
    if columns[1:2] == ['154,']:
        field_list_154.append(float(columns[5:6][0]))
        data_list_154.append(float(columns[12:13][0]))
    if columns[1:2] == ['155,']:
        field_list_155.append(float(columns[5:6][0]))
        data_list_155.append(float(columns[12:13][0]))
fin.close()
 
# Adjust data for plotting on an absolute scale
# At each field, add the threshold energy 
data_output_153 = []
data_output_154 = []
data_output_155 = []
for N in range(len(field_values)):
    for i in range(len(data_list_153)):
        if (field_values[N] == field_list_153[i]):
            result = data_list_153[i] + energy_1_list[N]
            data_output_153.append(result)
    for i in range(len(data_list_154)):
        if (field_values[N] == field_list_154[i]):
            result = data_list_154[i] + energy_1_list[N]
            data_output_154.append(result)
    for i in range(len(data_list_155)):
        if (field_values[N] == field_list_155[i]):
            result = data_list_155[i] + energy_1_list[N]
            data_output_155.append(result)
# ----------------------------------------------------------------------------
# ----------------------------------------------------------------------------
# data from file loaded into L2_plot.py for plotting. 