# LOAD DATA FROM INDIVIDUAL FILES

# The energies tabulated here and used in Figure 10 were calculated using 
# $g_\mathrm{Na} = -8.8046108 \times 10^{-4}$, which differs from the correct 
# value $g_\mathrm{Na} = -8.046108 \times 10^{-4}$. The energies are affected 
# by less than 500 kHz even at the highest fields shown, and the differences 
# are not visible on the scale of Figure 10. The energies used in Figures 11 
# and 12 used the correct value of $g_\mathrm{Na}$.

import numpy as np

# LOAD THE THRESHOLD DATA.
# ---------------------------------------------------------------------------
fin = open("mf1_threshold.txt", "r")
energy_1 = []
for line in fin:
    columns = line.split()
    energy_1.append(columns[6:7])
fin.close()
energy_1_list = []
for i in energy_1 :
    for x in i :
        energy_1_list.append(float(x)-(-6278.12170297))


fin = open("mf2_threshold.txt", "r")
energy_2 = []
for line in fin:
    columns = line.split()
    energy_2.append(columns[6:7])
fin.close()


energy_2_list = []
for i in energy_2 :
    for x in i :
        energy_2_list.append(float(x)-(-6278.12170297))
        
        
fin = open("mf3_threshold.txt", "r")
energy_3 = []
for line in fin:
    columns = line.split()
    energy_3.append(columns[6:7])
fin.close()


energy_3_list = []
for i in energy_3 :
    for x in i :
        energy_3_list.append(float(x)-(-6278.12170297))
        
            
fin = open("mf4_threshold.txt", "r")
energy_4 = []
for line in fin:
    columns = line.split()
    energy_4.append(columns[6:7])
fin.close()


energy_4_list = []
for i in energy_4 :
    for x in i :
        energy_4_list.append(float(x)-(-6278.12170297))
        
        
fin = open("mf5_threshold.txt", "r")
energy_5 = []
for line in fin:
    columns = line.split()
    energy_5.append(columns[6:7])
fin.close()


energy_5_list = []
for i in energy_5 :
    for x in i :
        energy_5_list.append(float(x)-(-6278.12170297))


fin = open("mf6_threshold.txt", "r")
energy_6 = []
for line in fin:
    columns = line.split()
    energy_6.append(columns[6:7])
fin.close()


energy_6_list = []
for i in energy_6 :
    for x in i :
        energy_6_list.append(float(x)-(-6278.12170297))


field_values = np.arange(0,1402,2).tolist()

# --------------------------------------------------------------------------- 



# --------------------------------------------------------------------------- 
# LOAD THE STATE ENERGIES.
# --------------------------------------------------------------------------- 


# MF1
# ---------------------------------------------------------------------------
fin = open("mf1_states.txt", "r")
field_list_612 = []
data_list_612  = []
field_list_613 = []
data_list_613  = []
field_list_614 = []
data_list_614  = []
field_list_615 = []
data_list_615  = []
field_list_616 = []
data_list_616  = []
field_list_617 = []
data_list_617  = []
field_list_618 = []
data_list_618  = []
field_list_619 = []
data_list_619  = []
field_list_620 = []
data_list_620  = []
field_list_621 = []
data_list_621  = []
field_list_622 = []
data_list_622  = []
field_list_623 = []
data_list_623  = []
field_list_624 = []
data_list_624  = []
field_list_625 = []
data_list_625  = []
field_list_626 = []
data_list_626  = []
field_list_627 = []
data_list_627  = []
field_list_628 = []
data_list_628  = []
field_list_629 = []
data_list_629  = []
field_list_630 = []
data_list_630  = []
field_list_631 = []
data_list_631  = []


for line in fin:
    columns = line.split()
    if (columns[1:2] == ['612,']):
        field_list_612.append(float(columns[5:6][0]))
        data_list_612.append(float(columns[12:13][0]))
    if (columns[1:2] == ['613,']):
        field_list_613.append(float(columns[5:6][0]))
        data_list_613.append(float(columns[12:13][0]))  
    if (columns[1:2] == ['614,']):
        field_list_614.append(float(columns[5:6][0]))
        data_list_614.append(float(columns[12:13][0]))  
    if (columns[1:2] == ['615,']):
        field_list_615.append(float(columns[5:6][0]))
        data_list_615.append(float(columns[12:13][0]))  
    if (columns[1:2] == ['616,']):
        field_list_616.append(float(columns[5:6][0]))
        data_list_616.append(float(columns[12:13][0]))  
    if (columns[1:2] == ['617,']):
        field_list_617.append(float(columns[5:6][0]))
        data_list_617.append(float(columns[12:13][0]))
    if (columns[1:2] == ['618,']):
        field_list_618.append(float(columns[5:6][0]))
        data_list_618.append(float(columns[12:13][0]))  
    if (columns[1:2] == ['619,']):
        field_list_619.append(float(columns[5:6][0]))
        data_list_619.append(float(columns[12:13][0]))  
    if (columns[1:2] == ['620,']):
        field_list_620.append(float(columns[5:6][0]))
        data_list_620.append(float(columns[12:13][0]))
    if (columns[1:2] == ['621,']):
        field_list_621.append(float(columns[5:6][0]))
        data_list_621.append(float(columns[12:13][0])) 
    if (columns[1:2] == ['622,']):
        field_list_622.append(float(columns[5:6][0]))
        data_list_622.append(float(columns[12:13][0])) 
    if (columns[1:2] == ['623,']):
        field_list_623.append(float(columns[5:6][0]))
        data_list_623.append(float(columns[12:13][0])) 
    if (columns[1:2] == ['624,']):
        field_list_624.append(float(columns[5:6][0]))
        data_list_624.append(float(columns[12:13][0])) 
    if (columns[1:2] == ['625,']):
        field_list_625.append(float(columns[5:6][0]))
        data_list_625.append(float(columns[12:13][0]))
    if (columns[1:2] == ['626,']):
        field_list_626.append(float(columns[5:6][0]))
        data_list_626.append(float(columns[12:13][0]))
    if (columns[1:2] == ['627,']):
        field_list_627.append(float(columns[5:6][0]))
        data_list_627.append(float(columns[12:13][0]))
    if (columns[1:2] == ['628,']):
        field_list_628.append(float(columns[5:6][0]))
        data_list_628.append(float(columns[12:13][0]))
    if (columns[1:2] == ['629,']):
        field_list_629.append(float(columns[5:6][0]))
        data_list_629.append(float(columns[12:13][0])) 
    if (columns[1:2] == ['630,']):
        field_list_630.append(float(columns[5:6][0]))
        data_list_630.append(float(columns[12:13][0])) 
    if (columns[1:2] == ['631,']):
        field_list_631.append(float(columns[5:6][0]))
        data_list_631.append(float(columns[12:13][0])) 
fin.close()

# adjust for absolute values and thresholds
field_output_612 = []
data_output_612 = []
field_output_613 = []
data_output_613 = []
field_output_614 = []
data_output_614 = []
field_output_615 = []
data_output_615 = []
field_output_616 = []
data_output_616 = []
field_output_617 = []
data_output_617 = []
field_output_618 = []
data_output_618 = []
field_output_619 = []
data_output_619 = []
field_output_620 = []
data_output_620 = []
field_output_621 = []
data_output_621 = []
field_output_622 = []
data_output_622 = []
field_output_623 = []
data_output_623 = []
field_output_624 = []
data_output_624 = []
field_output_625 = []
data_output_625 = []
field_output_626 = []
data_output_626 = []
field_output_627 = []
data_output_627 = []
field_output_628 = []
data_output_628 = []
field_output_629 = []
data_output_629 = []
field_output_630 = []
data_output_630 = []
field_output_631 = []
data_output_631 = []
for N in range(len(field_values)):
    for i in range(len(data_list_612)):
        if (field_values[N] == field_list_612[i]):
            result = data_list_612[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_612.append(result)
                field_output_612.append(field_list_612[i])
    for i in range(len(data_list_613)):
        if (field_values[N] == field_list_613[i]):
            result = data_list_613[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_613.append(result)
                field_output_613.append(field_list_613[i])
    for i in range(len(data_list_614)):
        if (field_values[N] == field_list_614[i]):
            result = data_list_614[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_614.append(result)
                field_output_614.append(field_list_614[i])
    for i in range(len(data_list_615)):
        if (field_values[N] == field_list_615[i]):
            result = data_list_615[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_615.append(result)
                field_output_615.append(field_list_615[i])
    for i in range(len(data_list_616)):
        if (field_values[N] == field_list_616[i]):
            result = data_list_616[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_616.append(result)
                field_output_616.append(field_list_616[i])
    for i in range(len(data_list_617)):
        if (field_values[N] == field_list_617[i]):
            result = data_list_617[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_617.append(result)
                field_output_617.append(field_list_617[i])
    for i in range(len(data_list_618)):
        if (field_values[N] == field_list_618[i]):
            result = data_list_618[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_618.append(result)
                field_output_618.append(field_list_618[i])
    for i in range(len(data_list_619)):
        if (field_values[N] == field_list_619[i]):
            result = data_list_619[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_619.append(result)
                field_output_619.append(field_list_619[i])
    for i in range(len(data_list_620)):
        if (field_values[N] == field_list_620[i]):
            result = data_list_620[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_620.append(result)
                field_output_620.append(field_list_620[i])
    for i in range(len(data_list_621)):
        if (field_values[N] == field_list_621[i]):
            result = data_list_621[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_621.append(result)
                field_output_621.append(field_list_621[i])
    # DIFFERENT FORMATTING FOR THESE LAST STATES TO AVOID THE PRESENCE OF THRESHOLD
    for i in range(len(data_list_622)):
        if (field_values[N] == field_list_622[i]):
            result = data_list_622[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_622.append(result)
                field_output_622.append(field_list_622[i])
    for i in range(len(data_list_623)):
        if (field_values[N] == field_list_623[i]):
            result = data_list_623[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_623.append(result)
                field_output_623.append(field_list_623[i])
    for i in range(len(data_list_624)):
        if (field_values[N] == field_list_624[i]):
            result = data_list_624[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_624.append(result)
                field_output_624.append(field_list_624[i])
    for i in range(len(data_list_625)):
        if (field_values[N] == field_list_625[i]):
            result = data_list_625[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_625.append(result)
                field_output_625.append(field_list_625[i])
    for i in range(len(data_list_626)):
        if (field_values[N] == field_list_626[i]):
            result = data_list_626[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_626.append(result)
                field_output_626.append(field_list_626[i])
    for i in range(len(data_list_627)):
        if (field_values[N] == field_list_627[i]):
            result = data_list_627[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_627.append(result)
                field_output_627.append(field_list_627[i])
    for i in range(len(data_list_628)):
        if (field_values[N] == field_list_628[i]):
            result = data_list_628[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_628.append(result)
                field_output_628.append(field_list_628[i])
    for i in range(len(data_list_629)):
        if (field_values[N] == field_list_629[i]):
            result = data_list_629[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_629.append(result)
                field_output_629.append(field_list_629[i])
    for i in range(len(data_list_630)):
        if (field_values[N] == field_list_630[i]):
            result = data_list_630[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_630.append(result)
                field_output_630.append(field_list_630[i])
    for i in range(len(data_list_631)):
        if (field_values[N] == field_list_631[i]):
            result = data_list_631[i] + energy_1_list[N]
            if (result < (energy_4_list[N])):
                data_output_631.append(result)
                field_output_631.append(field_list_631[i])
# ---------------------------------------------------------------------------




                
                
                
# MF2
# ---------------------------------------------------------------------------
fin = open("mf2_states.txt", "r")
field_list_606 = []
data_list_606  = []
field_list_605 = []
data_list_605  = []
field_list_604 = []
data_list_604  = []
field_list_603 = []
data_list_603  = []
field_list_602 = []
data_list_602  = []
field_list_601 = []
data_list_601  = []
field_list_600 = []
data_list_600  = []
field_list_599 = []
data_list_599  = []
field_list_598 = []
data_list_598  = []
field_list_597 = []
data_list_597  = []
field_list_596 = []
data_list_596  = []
field_list_595 = []
data_list_595  = []
field_list_594 = []
data_list_594  = []
field_list_593 = []
data_list_593  = []
field_list_592 = []
data_list_592  = []
field_list_591 = []
data_list_591  = []
field_list_590 = []
data_list_590  = []

for line in fin:
    columns = line.split()
    if columns[1:2] == ['606,']:
        field_list_606.append(float(columns[5:6][0]))
        data_list_606.append(float(columns[12:13][0]))
    if columns[1:2] == ['605,']:
        field_list_605.append(float(columns[5:6][0]))
        data_list_605.append(float(columns[12:13][0]))
    if columns[1:2] == ['604,']:
        field_list_604.append(float(columns[5:6][0]))
        data_list_604.append(float(columns[12:13][0]))
    if columns[1:2] == ['603,']:
        field_list_603.append(float(columns[5:6][0]))
        data_list_603.append(float(columns[12:13][0]))
    if columns[1:2] == ['602,']:
        field_list_602.append(float(columns[5:6][0]))
        data_list_602.append(float(columns[12:13][0]))
    if columns[1:2] == ['601,']:
        field_list_601.append(float(columns[5:6][0]))
        data_list_601.append(float(columns[12:13][0]))
    if columns[1:2] == ['600,']:
        field_list_600.append(float(columns[5:6][0]))
        data_list_600.append(float(columns[12:13][0]))
    if columns[1:2] == ['599,']:
        field_list_599.append(float(columns[5:6][0]))
        data_list_599.append(float(columns[12:13][0]))  
    if columns[1:2] == ['598,']:
        field_list_598.append(float(columns[5:6][0]))
        data_list_598.append(float(columns[12:13][0]))  
    if columns[1:2] == ['597,']:
        field_list_597.append(float(columns[5:6][0]))
        data_list_597.append(float(columns[12:13][0]))  
    if columns[1:2] == ['596,']:
        field_list_596.append(float(columns[5:6][0]))
        data_list_596.append(float(columns[12:13][0]))  
    if columns[1:2] == ['595,']:
        field_list_595.append(float(columns[5:6][0]))
        data_list_595.append(float(columns[12:13][0]))  
    if columns[1:2] == ['594,']:
        field_list_594.append(float(columns[5:6][0]))
        data_list_594.append(float(columns[12:13][0]))
    if columns[1:2] == ['593,']:
        field_list_593.append(float(columns[5:6][0]))
        data_list_593.append(float(columns[12:13][0]))
    if columns[1:2] == ['592,']:
        field_list_592.append(float(columns[5:6][0]))
        data_list_592.append(float(columns[12:13][0])) 
    if columns[1:2] == ['591,']:
        field_list_591.append(float(columns[5:6][0]))
        data_list_591.append(float(columns[12:13][0]))  
    if columns[1:2] == ['590,']: 
        field_list_590.append(float(columns[5:6][0]))
        data_list_590.append(float(columns[12:13][0])) 
fin.close()
  
# adjust for absolute values and thresholds
field_output_606 = []
data_output_606 = []
field_output_605 = []
data_output_605 = []
field_output_604 = []
data_output_604 = []
field_output_603 = []
data_output_603 = []
field_output_602 = []
data_output_602 = []
field_output_601 = []
data_output_601 = []
field_output_600 = []
data_output_600 = []
field_output_599 = []
data_output_599 = []
field_output_598 = []
data_output_598 = []
field_output_597 = []
data_output_597 = []
field_output_596 = []
data_output_596 = []
field_output_595 = []
data_output_595 = []
field_output_594 = []
data_output_594 = []
field_output_593 = []
data_output_593 = []
field_output_592 = []
data_output_592 = []
field_output_591 = []
data_output_591 = []
field_output_590 = []
data_output_590 = []
for N in range(len(field_values)):
    for i in range(len(data_list_590)):
        if (field_values[N] == field_list_590[i]):
            result = data_list_590[i] + energy_2_list[N]
            if (result < (energy_1_list[N])):
                data_output_590.append(result)
                field_output_590.append(field_list_590[i])
    for i in range(len(data_list_591)):
        if (field_values[N] == field_list_591[i]):
            result = data_list_591[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_591.append(result)
                field_output_591.append(field_list_591[i])
    for i in range(len(data_list_592)):
        if (field_values[N] == field_list_592[i]):
            result = data_list_592[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_592.append(result)
                field_output_592.append(field_list_592[i])
    for i in range(len(data_list_593)):
        if (field_values[N] == field_list_593[i]):
            result = data_list_593[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_593.append(result)
                field_output_593.append(field_list_593[i])
    for i in range(len(data_list_594)):
        if (field_values[N] == field_list_594[i]):
            result = data_list_594[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_594.append(result)
                field_output_594.append(field_list_594[i])
    for i in range(len(data_list_595)):
        if (field_values[N] == field_list_595[i]):
            result = data_list_595[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_595.append(result)
                field_output_595.append(field_list_595[i])
    for i in range(len(data_list_596)):
        if (field_values[N] == field_list_596[i]):
            result = data_list_596[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_596.append(result)
                field_output_596.append(field_list_596[i])
    for i in range(len(data_list_597)):
        if (field_values[N] == field_list_597[i]):
            result = data_list_597[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_597.append(result)
                field_output_597.append(field_list_597[i])
    for i in range(len(data_list_598)):
        if (field_values[N] == field_list_598[i]):
            result = data_list_598[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_598.append(result)
                field_output_598.append(field_list_598[i])
    for i in range(len(data_list_599)):
        if (field_values[N] == field_list_599[i]):
            result = data_list_599[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_599.append(result)
                field_output_599.append(field_list_599[i])
    # DIFFERENT FORMATTING FOR THESE LAST STATES TO AVOID THE PRESENCE OF THRESHOLD
    for i in range(len(data_list_600)):
        if (field_values[N] == field_list_600[i]):
            result = data_list_600[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_600.append(result)
                field_output_600.append(field_list_600[i])
    for i in range(len(data_list_601)):
        if (field_values[N] == field_list_601[i]):
            result = data_list_601[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_601.append(result)
                field_output_601.append(field_list_601[i])
    for i in range(len(data_list_602)):
        if (field_values[N] == field_list_602[i]):
            result = data_list_602[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_602.append(result)
                field_output_602.append(field_list_602[i])
    for i in range(len(data_list_603)):
        if (field_values[N] == field_list_603[i]):
            result = data_list_603[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_603.append(result)
                field_output_603.append(field_list_603[i])
    for i in range(len(data_list_604)):
        if (field_values[N] == field_list_604[i]):
            result = data_list_604[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_604.append(result)
                field_output_604.append(field_list_604[i])
    for i in range(len(data_list_605)):
        if (field_values[N] == field_list_600[i]):
            result = data_list_605[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_605.append(result)
                field_output_605.append(field_list_605[i])
    for i in range(len(data_list_606)):
        if (field_values[N] == field_list_606[i]):
            result = data_list_606[i] + energy_2_list[N]
            if (result < (energy_4_list[N])):
                data_output_606.append(result)
                field_output_606.append(field_list_606[i])
# ---------------------------------------------------------------------------



# MF3
# ---------------------------------------------------------------------------
fin = open("mf3_states.txt", "r")
field_list_461 = []
data_list_461  = []
field_list_462 = []
data_list_462  = []
field_list_463 = []
data_list_463  = []
field_list_464 = []
data_list_464  = []
field_list_465 = []
data_list_465  = []
field_list_466 = []
data_list_466  = []
field_list_467 = []
data_list_467  = []
field_list_468 = []
data_list_468  = []
field_list_469 = []
data_list_469  = []
for line in fin:
    columns = line.split()
    if columns[1:2] == ['461,']:
        field_list_461.append(float(columns[5:6][0]))
        data_list_461.append(float(columns[12:13][0]))
    if columns[1:2] == ['462,']:
        field_list_462.append(float(columns[5:6][0]))
        data_list_462.append(float(columns[12:13][0]))
    if columns[1:2] == ['463,']:
        field_list_463.append(float(columns[5:6][0]))
        data_list_463.append(float(columns[12:13][0]))  
    if columns[1:2] == ['464,']:
        field_list_464.append(float(columns[5:6][0]))
        data_list_464.append(float(columns[12:13][0]))  
    if columns[1:2] == ['465,']:
        field_list_465.append(float(columns[5:6][0]))
        data_list_465.append(float(columns[12:13][0]))  
    if columns[1:2] == ['466,']:
        field_list_466.append(float(columns[5:6][0]))
        data_list_466.append(float(columns[12:13][0]))  
    if columns[1:2] == ['467,']:
        field_list_467.append(float(columns[5:6][0]))
        data_list_467.append(float(columns[12:13][0]))  
    if columns[1:2] == ['468,']:
        field_list_468.append(float(columns[5:6][0]))
        data_list_468.append(float(columns[12:13][0]))
    if columns[1:2] == ['469,']:
        field_list_469.append(float(columns[5:6][0]))
        data_list_469.append(float(columns[12:13][0]))  
fin.close()

# adjust for absolute values and thresholds
field_output_461 = []
data_output_461 = []
field_output_462 = []
data_output_462 = []
field_output_463 = []
data_output_463 = []
field_output_464 = []
data_output_464 = []
field_output_465 = []
data_output_465 = []
field_output_466 = []
data_output_466 = []
field_output_467 = []
data_output_467 = []
field_output_468 = []
data_output_468 = []
field_output_469 = []
data_output_469 = []
for N in range(len(field_values)):
    for i in range(len(data_list_461)):
        if (field_values[N] == field_list_461[i]):
            result = data_list_461[i] + energy_3_list[N]
            if (result < (energy_4_list[N])):
                data_output_461.append(result)
                field_output_461.append(field_list_461[i])
    for i in range(len(data_list_462)):
        if (field_values[N] == field_list_462[i]):
            result = data_list_462[i] + energy_3_list[N]
            if (result < (energy_4_list[N])):
                data_output_462.append(result)
                field_output_462.append(field_list_462[i])
    for i in range(len(data_list_463)):
        if (field_values[N] == field_list_463[i]):
            result = data_list_463[i] + energy_3_list[N]
            if (result < (energy_4_list[N])):
                data_output_463.append(result)
                field_output_463.append(field_list_463[i])
    for i in range(len(data_list_464)):
        if (field_values[N] == field_list_464[i]):
            result = data_list_464[i] + energy_3_list[N]
            if (result < (energy_4_list[N])):
                data_output_464.append(result)
                field_output_464.append(field_list_464[i])
    for i in range(len(data_list_465)):
        if (field_values[N] == field_list_465[i]):
            result = data_list_465[i] + energy_3_list[N]
            if (result < (energy_4_list[N])):
                data_output_465.append(result)
                field_output_465.append(field_list_465[i])
    for i in range(len(data_list_466)):
        if (field_values[N] == field_list_466[i]):
            result = data_list_466[i] + energy_3_list[N]
            if (result < (energy_4_list[N])):
                data_output_466.append(result)
                field_output_466.append(field_list_466[i])
    for i in range(len(data_list_467)):
        if (field_values[N] == field_list_467[i]):
            result = data_list_467[i] + energy_3_list[N]
            if (result < (energy_4_list[N])):
                data_output_467.append(result)
                field_output_467.append(field_list_467[i])
    for i in range(len(data_list_468)):
        if (field_values[N] == field_list_468[i]):
            result = data_list_468[i] + energy_3_list[N]
            if (result < (energy_4_list[N])):
                data_output_468.append(result)
                field_output_468.append(field_list_468[i])
    for i in range(len(data_list_469)):
        if (field_values[N] == field_list_469[i]):
            result = data_list_469[i] + energy_3_list[N]
            if (result < (energy_4_list[N])):
                data_output_469.append(result)
                field_output_469.append(field_list_469[i])
# ---------------------------------------------------------------------------                


# MF4
# ---------------------------------------------------------------------------
fin = open("mf4_states.txt", "r")
field_list_312 = []
data_list_312  = []
field_list_311 = []
data_list_311  = []
field_list_310 = []
data_list_310  = []
field_list_309 = []
data_list_309  = []
field_list_308 = []
data_list_308  = []
field_list_307 = []
data_list_307  = []
field_list_306 = []
data_list_306  = []
for line in fin:
    columns = line.split()
    if columns[1:2] == ['312,']:
        field_list_312.append(float(columns[5:6][0]))
        data_list_312.append(float(columns[12:13][0]))
    if columns[1:2] == ['311,']:
        field_list_311.append(float(columns[5:6][0]))
        data_list_311.append(float(columns[12:13][0]))
    if columns[1:2] == ['310,']:
        field_list_310.append(float(columns[5:6][0]))
        data_list_310.append(float(columns[12:13][0])) 
    if columns[1:2] == ['309,']:
        field_list_309.append(float(columns[5:6][0]))
        data_list_309.append(float(columns[12:13][0]))  
    if columns[1:2] == ['308,']:
        field_list_308.append(float(columns[5:6][0]))
        data_list_308.append(float(columns[12:13][0]))  
    if columns[1:2] == ['307,']:
        field_list_307.append(float(columns[5:6][0]))
        data_list_307.append(float(columns[12:13][0]))
    if columns[1:2] == ['306,']:
        field_list_306.append(float(columns[5:6][0]))
        data_list_306.append(float(columns[12:13][0]))
fin.close()

 
# adjust for absolute values and thresholds
field_output_312 = []
data_output_312 = []
field_output_311 = []
data_output_311 = []
field_output_310 = []
data_output_310 = []
field_output_309 = []
data_output_309 = []
field_output_308 = []
data_output_308 = []
field_output_307 = []
data_output_307 = []
field_output_306 = []
data_output_306 = []
for N in range(len(field_values)):
    for i in range(len(data_list_312)):
        if (field_values[N] == field_list_312[i]):
            result = data_list_312[i] + energy_4_list[N]
            data_output_312.append(result)
for N in range(len(field_values)):
    for i in range(len(data_list_311)):
        if (field_values[N] == field_list_311[i]):
            result = data_list_311[i] + energy_4_list[N]
            data_output_311.append(result)
for N in range(len(field_values)):
    for i in range(len(data_list_310)):
        if (field_values[N] == field_list_310[i]):
            result = data_list_310[i] + energy_4_list[N]
            data_output_310.append(result)      
for N in range(len(field_values)):
    for i in range(len(data_list_309)):
        if (field_values[N] == field_list_309[i]):
            result = data_list_309[i] + energy_4_list[N]
            data_output_309.append(result)
for N in range(len(field_values)):
    for i in range(len(data_list_308)):
        if (field_values[N] == field_list_308[i]):
            result = data_list_308[i] + energy_4_list[N]
            data_output_308.append(result)
for N in range(len(field_values)):
    for i in range(len(data_list_307)):
        if (field_values[N] == field_list_307[i]):
            result = data_list_307[i] + energy_4_list[N]
            data_output_307.append(result)
for N in range(len(field_values)):
    for i in range(len(data_list_306)):
        if (field_values[N] == field_list_306[i]):
            result = data_list_306[i] + energy_4_list[N]
            data_output_306.append(result)
# ---------------------------------------------------------------------------


             

# MF5
# ---------------------------------------------------------------------------           
fin = open("mf5_states.txt", "r")
field_list_153 = []
data_list_153  = []
field_list_154 = []
data_list_154  = []
field_list_155 = []
data_list_155  = []
for line in fin:
    columns = line.split()
    if columns[1:2] == ['153,']:
        field_list_153.append(float(columns[5:6][0]))
        data_list_153.append(float(columns[12:13][0]))
    if columns[1:2] == ['154,']:
        field_list_154.append(float(columns[5:6][0]))
        data_list_154.append(float(columns[12:13][0]))
    if columns[1:2] == ['155,']:
        field_list_155.append(float(columns[5:6][0]))
        data_list_155.append(float(columns[12:13][0]))
fin.close()

# adjust for absolute values and thresholds
field_output_153 = []
data_output_153 = []
field_output_154 = []
data_output_154 = []
field_output_155 = []
data_output_155 = []
for N in range(len(field_values)):
    for i in range(len(data_list_153)):
        if (field_values[N] == field_list_153[i]):
            result = data_list_153[i] + energy_5_list[N]
            if (result < (energy_4_list[N])):
                data_output_153.append(result)
                field_output_153.append(field_list_153[i])
    for i in range(len(data_list_154)):
        if (field_values[N] == field_list_154[i]):
            result = data_list_154[i] + energy_5_list[N]
            if (result < (energy_4_list[N])):
                data_output_154.append(result)
                field_output_154.append(field_list_154[i])
    for i in range(len(data_list_155)):
        if (field_values[N] == field_list_155[i]):
            result = data_list_155[i] + energy_5_list[N]
            if (result < (energy_4_list[N])):
                data_output_155.append(result)
                field_output_155.append(field_list_155[i])
# --------------------------------------------------------------------------- 



# MF6
# --------------------------------------------------------------------------- 
fin = open("mf6_states.txt", "r")
field_list_23 = []
data_list_23  = []
for line in fin:
    columns = line.split()
    if columns[1:2] == ['23,']:
        field_list_23.append(float(columns[5:6][0]))
        data_list_23.append(float(columns[12:13][0]))
fin.close()

# adjust for absolute values and thresholds
field_output_23 = []
data_output_23 = []
for N in range(len(field_values)):
    for i in range(len(data_list_23)):
        if (field_values[N] == field_list_23[i]):
            result = data_list_23[i] + energy_6_list[N]
            if (result < (energy_4_list[N])):
                data_output_23.append(result)
                field_output_23.append(field_list_23[i])
# --------------------------------------------------------------------------- 
# data from loaded into L0_PLOT.py for plotting. 