      module pot_data_Tiemann
C
C     MODULE CONTAINING PARAMETERS OF A PAIR OF TIEMANN-STYLE
C     POTENTIAL CURVES OF AN ALKALI DIMER
C     UNITS USED ARE CM-1 AND POWERS OF ANGSTROM
C     UPDATED POTENTIAL REPRODUCING FOUR EXPERIMENTAL OBSERVABLES
C     TAKEN FROM 
C             Zhang et al. (2020)
C             Yu et al. (2020)
C             Hood et al. (2020)
C             Cairncross et al. (2021) 
C
C     POTENTIAL 1 IS SINGLET X, POTENTIAL 2 IS TRIPLET A
C
      USE physical_constants, ONLY: bohr_to_Angstrom
      SAVE
C
      CHARACTER(96) :: POTNAM =
     X ' NaCs parameters of Docenko et al., J Phys B 39, S929 (2006).'//
     X ' Original with discontinuity at RSR'
C
C     PRINT CONTROL (FOR POTENTIAL ROUTINE ONLY)
C     0 = SILENT, 1 = TITLE, 2 = INTERNALLY CALCULATED PARAMETERS
C
      INTEGER IPRINT/2/
C
C     NUMBER OF TERMS IN POWER SERIES FOR CENTRAL REGION
C     (NOTE: HIGHEST POWER + 1 BECAUSE ARRAYS START AT 0)
C
      INTEGER :: NA(2) = (/30,21/)
C
C     EXPANSION COEFFICIENTS:
C
      DOUBLE PRECISION :: A(0:29,2) = reshape((/
     X  -4954.229485141D0,
     X   0.8986226306643612D0,
     X   0.1517322178913964D5,
     X   0.1091020582856565D5,
     X  -0.2458305372316654D4,
     X  -0.1608232170898541D5,
     X  -0.8705012336065982D4,
     X   0.2188049902097992D5,
     X  -0.3002538575091348D6,
     X  -0.7869349638160045D6,
     X   0.3396165699038170D7,
     X   0.7358409786704151D7,
     X  -0.2637478410890963D8,
     X  -0.4458510225166618D8,
     X   0.1351336683376161D9,
     X   0.1762627710924772D9,
     X  -0.4756878196167457D9,
     X  -0.4474883319488960D9,
     X   0.1216000437881570D10,
     X   0.7460756868876818D9,
     X  -0.2291733580271494D10,
     X  -0.8708937018502138D9,
     X   0.3095441526749659D10,
     X   0.8199544778493311D9,
     X  -0.2806754517994001D10,
     X  -0.6963731313587832D9,
     X   0.1516535916964652D10,
     X   0.4445582751072266D9,
     X  -0.3669908996749862D9,
     X  -0.1352434762493831D9,

     a  -217.1467658651D0,
     a   5.060036971084974D0,
     a   0.4718680742883366D3,
     a   0.2514218966583440D3,
     a  -0.8746237641947566D2,
     a  -0.2154125514807857D3,
     a  -0.2370010946769863D3,
     a  -0.5975521818660835D3,
     a  -0.4760138019137823D3,
     a   0.3782292848644752D3,
     a   0.6798270085678005D3,
     a   0.6723272497875273D3,
     a  -0.1247569396700132D2,
     a  -0.4625610662820737D3,
     a    0.D0, 0.D0, 0.D0, 0.D0, 0.D0, 0.D0, 0.D0, 0.D0,
     a    0.D0, 0.D0, 0.D0, 0.D0, 0.D0, 0.D0, 0.D0, 0.D0 /), shape(A))
C
C     LOGICAL VARIABLES TO CONTROL CONTINUITY MATCHING:
C
      LOGICAL :: MATCHL = .TRUE., MATCHV = .TRUE., MATCHD = .TRUE.
C
C     IF (MATCHL), ADJUST A(0) TO MAKE POTENTIAL  CONTINUOUS AT RLR
C     IF (MATCHL), ADJUST ASR  TO MAKE POTENTIAL  CONTINUOUS AT RSR
C     IF (MATCHD), ADJUST BSR  TO MAKE DERIVATIVE CONTINUOUS AT RSR
C     IF .FALSE., USE THE CORRESPONDING INPUT VALUE UNCHANGED AND
C     PRINT THE RESULTING MISMATCH FOR INFORMATION.
C
C     RM AND B ARE USED IN DEFINITION THE OF XI.
C     RSR AND RLR ARE SHORT-RANGE AND LONG-RANGE MATCHING POINTS.
C     PARAMETERS OF SHORT-RANGE POTENTIAL ASR + BSR*R**NSR.
C     -0.147429182D+04 (Original ASR Triplet)
C
       DOUBLE PRECISION ::  DUM = 1.7D0,
     X  RM(2)  = (/3.85062906D0, 5.75585938D0/),
     X  B(2)   = (/-0.40D0, -0.64D0/),
     X  RSR(2) = (/2.873240D0, 4.772797D0/),
     X  RLR(2) = (/10.20D0, 10.20D0/),
     X  NSR(2) = (/10.D0, 10.D0/),
     X  ASR(2) = (/-3.798020052289D+03, -4.205369634791D+02/),
     X  BSR(2) = (/ 1.309711255476D+08,  2.560412914350D+09/)
C
C     DISPERSION COEFFICIENTS
C
       DOUBLE PRECISION ::
     X  C6  = 1.568975D+07,
     X  C8  = 4.815171D+08,
     X  C10 = 1.971387D+10
C
C     POTENTIALS OCCASIONALLY HAVE AN EXTRA TERM -CEX/R**NEX IN V_LR
C     SET NEX = 0 TO SWITCH THIS OFF
C
      INTEGER :: NEX = 0
      DOUBLE PRECISION :: CEX = 0.D0
C
C     PARAMETERS OF EXCHANGE POTENTIAL
C     NOTE THAT BETA AND GAMMA ARE CONVENTIONALLY LINKED.
C     THREE OPTIONS ARE IMPLEMENTED HERE:
C        GAMBET = 0: USE INPUT VALUES UNCHANGED
C        GAMBET = 1: CALCULATE GAMMA FROM BETA
C        GAMBET = 2: CALCULATE BETA FROM GAMMA
C     IF CHANGED, THE INPUT VALUE IS PRINTED FOR COMPARISON
C
       INTEGER :: GAMBET = 0
       DOUBLE PRECISION ::
     X  EXSIGN(2) = (/-1.D0, +1.D0/),
     X  AEX = 2.549087D+04,
     X  GAMMA = 5.12271D0,
     X  BETA  = 2.17237D0
C
C     DISTANCE UNITS TO BE USED BY MOLSCAT/BOUND:
C     1.D0 FOR ANGSTROM, 0.529... FOR BOHR, ETC.
C
      DOUBLE PRECISION :: RUNITM = bohr_to_Angstrom
      CHARACTER(8) :: LENUNT='BOHR'
C
C     COMMON BLOCK TO BE USED FOR ANY PARAMETERS TO BE CHANGED BY
C     OTHER ROUTINES, FOR EXAMPLE WHEN LEAST-SQUARES FITTING
C
      COMMON/POTEXT/NSR
C
      end module pot_data_Tiemann
