# PLOT OF P-WAVE SCATTERING IN THE AA CHANNEL WHERE LMAX = 1

import matplotlib.pyplot as plt
from matplotlib.ticker import (MultipleLocator, AutoMinorLocator)
import numpy as np

from data import *

# FONT -----------------------------------------------------------------------
rc = {"font.family" : "serif", 
      "mathtext.fontset" : "stix"}
plt.rcParams.update(rc)
# ----------------------------------------------------------------------------


# PLOTS
# THREE PANNELS DETAILING THE SCATTERING LENGTH, THE BOUND STATES ON A RELATIVE 
# ENERGY LEVEL, AND THE BOUND STATES ON AN ABSOLUTE ENERGY SCALE.
# ----------------------------------------------------------------------------
fig, (ax1, ax2, ax3) = plt.subplots(3,1,sharex=True,figsize=(6,12),gridspec_kw={'height_ratios': [1,1,4]})
plt.subplots_adjust(hspace=0.03)
# ----------------------------------------------------------------------------





# ----------------------------------------------------------------------------
# AX1
# PLOT OF THE SCATTERING LENGTHS.
# ----------------------------------------------------------------------------
line1 = ax1.plot(field_list,data1_list,'-',color='red')

# ax1 parameters
ax1.set_xlim(000,1400)
ax1.set_ylim(-15.9,-14)
ax1.set_ylabel(r'$v(B) \; (10^6 \: \mathrm{a_0^3}$)',size=17)
ax1.set_yticks(np.arange(-15.5,-13.5,0.5))
ax1.tick_params(axis="x",which='both',direction="in",labelsize=15)
ax1.tick_params(axis="y",which='both',direction="in",labelsize=15)
# ----------------------------------------------------------------------------





# ----------------------------------------------------------------------------
# AX2
# PLOT OF THE STATES ON A RELATIVE ENERGY SCALE.
# ----------------------------------------------------------------------------
threshold_ref = [[0,0],[1400,0]]
threshold = np.array(threshold_ref)
right_side_2 = ax2.spines["right"]
top_side_2 = ax2.spines["top"]
top_side_2.set_visible(False)


# THRESHOLD WHICH THE STATES ARE PLOTTED RELATIVE TO 
lineref2 = ax2.plot(threshold[:,0],threshold[:,1],'--',color='black',linewidth=1.5)

# BOUND STATES WITHIN 600 MHZ OF THE THRESHOLD
# MF4 STATES
line2 = ax2.plot(field_list_312,data_list_312,color='darkblue',linewidth=1)
line3 = ax2.plot(field_list_311,data_list_311,color='darkblue',linewidth=1)
line4 = ax2.plot(field_list_310,data_list_310,color='darkblue',linewidth=1)
line5 = ax2.plot(field_list_309,data_list_309,color='darkblue',linewidth=1)
line6 = ax2.plot(field_list_308,data_list_308,color='darkblue',linewidth=1)
line7 = ax2.plot(field_list_307,data_list_307,color='darkblue',linewidth=1)
line8 = ax2.plot(field_list_306,data_list_306,color='darkblue',linewidth=1)


# MF3 STATES
line17 = ax2.plot(field_list_469,data_list_469,color='firebrick',linewidth=1)
line18 = ax2.plot(field_list_468,data_list_468,color='firebrick',linewidth=1)
line19 = ax2.plot(field_list_467,data_list_467,color='firebrick',linewidth=1)
line20 = ax2.plot(field_list_466,data_list_466,color='firebrick',linewidth=1)
line21 = ax2.plot(field_list_465,data_list_465,color='firebrick',linewidth=1)
line22 = ax2.plot(field_list_464,data_list_464,color='firebrick',linewidth=1)
line23 = ax2.plot(field_list_463,data_list_463,color='firebrick',linewidth=1)
line24 = ax2.plot(field_list_462,data_list_462,color='firebrick',linewidth=1)
line25 = ax2.plot(field_list_461,data_list_461,color='firebrick',linewidth=1)
line25 = ax2.plot(field_list_460,data_list_460,color='firebrick',linewidth=1)
line25 = ax2.plot(field_list_459,data_list_459,color='firebrick',linewidth=1)

# MF5 STATES
line29 = ax2.plot(field_list_153,data_list_153,color='orange',linewidth=1)
line29 = ax2.plot(field_list_154,data_list_154,color='orange',linewidth=1)
line29 = ax2.plot(field_list_155,data_list_155,color='orange',linewidth=1)


# ax2 parameters
ax2.set_ylabel('$E/h$  (MHz)',size=18)
ax2.set_xlim(000,1400)
ax2.set_ylim(-550,0)
ax2.set_yticks(np.arange(-500,250,250))
ax2.yaxis.set_minor_locator(MultipleLocator(100))
ax2.xaxis.set_minor_locator(MultipleLocator(20))
ax2.tick_params(axis="x",which='both',direction="in",labelsize=16)
ax2.tick_params(axis="y",which='both',direction="in",labelsize=16)
# -----------------------------------------------------------------------------




# ----------------------------------------------------------------------------
# AX3 
# PLOT OF THE BOUND STATES ON AN ABSOLUTE SCALE.
# ----------------------------------------------------------------------------

# AA THRESHOLD
line_thresh = ax3.plot(field_values,energy_1_list,'--',color='black')


# MF4 STATES
line2 = ax3.plot(field_list_312,data_output_312,color='darkblue')
line3 = ax3.plot(field_list_311,data_output_311,color='darkblue')
line4 = ax3.plot(field_list_310,data_output_310,color='darkblue')
line5 = ax3.plot(field_list_309,data_output_309,color='darkblue')
line6 = ax3.plot(field_list_308,data_output_308,color='darkblue')
line7 = ax3.plot(field_list_307,data_output_307,color='darkblue')
line8 = ax3.plot(field_list_306,data_output_306,color='darkblue')

# MF3 STATES
line17 = ax3.plot(field_list_469,data_output_469,color='firebrick',linewidth=1)
line18 = ax3.plot(field_list_468,data_output_468,color='firebrick',linewidth=1)
line19 = ax3.plot(field_list_467,data_output_467,color='firebrick',linewidth=1)
line20 = ax3.plot(field_list_466,data_output_466,color='firebrick',linewidth=1)
line21 = ax3.plot(field_list_465,data_output_465,color='firebrick',linewidth=1)
line22 = ax3.plot(field_list_464,data_output_464,color='firebrick',linewidth=1)
line23 = ax3.plot(field_list_463,data_output_463,color='firebrick',linewidth=1)
line24 = ax3.plot(field_list_462,data_output_462,color='firebrick',linewidth=1)
line25 = ax3.plot(field_list_461,data_output_461,color='firebrick',linewidth=1)
line25 = ax3.plot(field_list_460,data_output_460,color='firebrick',linewidth=1)
line25 = ax3.plot(field_list_459,data_output_459,color='firebrick',linewidth=1)

# MF5 STATES
line29 = ax3.plot(field_list_153,data_output_153,color='orange',linewidth=1)
line29 = ax3.plot(field_list_154,data_output_154,color='orange',linewidth=1)
line29 = ax3.plot(field_list_155,data_output_155,color='orange',linewidth=1)


# ax3 parameters
ax3.set_ylabel('$E/h$  (MHz)',size=18)
ax3.set_xlabel('Magnetic field  (G)',size=18,labelpad=10)
ax3.set_ylim(-4200,50)
ax3.tick_params(axis="x",which='both',direction="in",labelsize=16)
ax3.tick_params(axis="y",which='both',direction="in",labelsize=16)
ax3.yaxis.set_minor_locator(MultipleLocator(100))
ax3.xaxis.set_minor_locator(MultipleLocator(20))
# ----------------------------------------------------------------------------


# ----------------------------------------------------------------------------
# FIGURE TEXT.
# ----------------------------------------------------------------------------
fig.text(0.68,0.58,'$L=1, M_F = 3$',color='firebrick',size=16)
fig.text(0.68,0.55,'$L=1, M_F = 4$',color='darkblue',size=16)
fig.text(0.68,0.52,'$L=1, M_F = 5$',color='orange',size=16)

fig.text(0.15,0.86,'(c)',size=17)
fig.text(0.15,0.725,'(b)',size=17)
fig.text(0.2,0.59,'(a)',size=17)
# ----------------------------------------------------------------------------
# ----------------------------------------------------------------------------

plt.show()

