      SUBROUTINE REINIV(SCALAM)
C  Copyright (C) 2020 J. M. Hutson & C. R. Le Sueur
C  Distributed under the GNU General Public License, version 3
C
C  REINIV IS CALLED FROM SETEFV IF IFVARY=0 OR SCALAM IS N0T 1.D0.
C  IT ALLOWS FITTING OF A (POTENTIALLY NONLINEAR) POTENTIAL PARAMETER
C  TO A SINGLE EXPERIMENTAL OBSERVABLE, USING THE CONVERGENCE
C  CAPABILITIES OF MOLSCAT OR FIELD.
C  IT REINITIALISES THE POTENTIAL ROUTINE WITH THE SELECTED
C  PARAMETER SET TO THE VALUE IN SCALAM, EQUIVALENT TO EFV(0).
C
C  THIS VERSION REINITIALIZES THE POTENTIAL ROUTINE
C  THAT IMPLEMENTS THE POTENTIAL FORM OF
C  TIEMANN AND CO-WORKERS FOR DIATOMIC POTENTIAL CURVES.
C  IT MAKES USE OF A MODULE pot_data_Tiemann THAT MUST CONTAIN THE
C  INITIAL POTENTIAL PARAMETERS FOR THE SPECIFIC SYSTEM.
C
C  THIS ROUTINE MUST BE USED WITH THE NULL VERSION OF SCAPOT.
C  ANY FIXED PARAMETERS REQUIRED CAN BE READ IN NAMELIST &EXTRA.
C
C  TO FIT OR SCAN A PARAMETER, CHOOSE THE REQUIRED PARAMETER
C  WITH IPAR AND NV, SET IFVARY=0 AND GIVE RANGE IN FLDMIN, FLDMAX.
C  IFCONV=0 SCANS AND OTHER VALUES FIT.
C
C  TO FIX ALL PARAMETERS, SET SCALAM TO THE VALUE GIVEN IN &EXTRA
C  FOR THE PARAMETER IDENTIFIED BY IPAR AND NV
C  (SINCE OTHERWISE REINIV IS NOT CALLED AT ALL: SEE ABOVE).
C  FLDMIN,FLDMAX CAN THEN BE USED TO VARY THE EFV IDENTIFIED BY IFVARY.
C
      USE pot_data_Tiemann
      IMPLICIT NONE
      INTEGER :: NV,IVAR
      DOUBLE PRECISION :: SCALAM
      DOUBLE PRECISION :: RUNIT,VUNIT
      LOGICAL :: FIRST = .TRUE.
      CHARACTER*3 :: PARNAM(10) = (/'RSR','NSR','BSR','RLR','AEX','C6 ',
     1                              '   ','C8 ','   ','C10'/)
      SAVE FIRST,NV,IVAR
C
      NAMELIST /EXTRA/ NV,IVAR,C6,C8,C10,AEX,NSR,RSR,BSR,RLR,
     1                 MATCHD,MATCHV,MATCHL
C
C  NV=1:  1SIGMA POTENTIAL
C  NV=2:  3SIGMA POTENTIAL
C
      IF (FIRST) THEN
C
C      READ ANY PARAMETERS TO BE CHANGED FROM DEFAULT VALUES INITIALLY
C
       NV=0
       READ(5,EXTRA)
       IPRINT=2
C
C      REINITIALISE BOTH POTENTIALS WITH ANY CHANGED PARAMETERS
C
       IF(NV.GT.0) THEN
         WRITE(6,100) PARNAM(IVAR),NV
  100    FORMAT(/'  SUBROUTINE REINIV MAPS POTENTIAL SCALING FACTOR',
     1         ' ONTO',A,' FOR POTENTIAL',I2)
       ELSE
         WRITE(6,200)
  200    FORMAT('  SUBROUTINE REINIV DOES NOT USE POTENTIAL SCALING',
     1         ' FACTOR BUT MAY READ IN MODIFIED PARAMETERS')
       ENDIF
       WRITE(6,*) ' IT REQUIRES A NULL VERSION OF SUBROUTINE SCAPOT'
       WRITE(6,*)
       WRITE(6,*) ' Reinitialise singlet and triplet potentials'
       WRITE(6,*) ' based on input values in namelist block EXTRA'
       WRITE(6,*) ' RSR =',RSR
       WRITE(6,*) ' NSR =',NSR
       WRITE(6,*) ' AEX =',AEX
       WRITE(6,*) ' RLR =',RLR
       WRITE(6,*) ' C6  =',C6
       WRITE(6,*) ' C8  =',C8
       WRITE(6,*) ' C10 =',C10
       IF (MATCHD) THEN
         WRITE(6,*) ' BSR obtained from continuity of derivative'
       ELSE
         WRITE(6,*) ' BSR =',BSR
       ENDIF 
       IF (MATCHV) THEN
         WRITE(6,*) ' ASR obtained from continuity of potential'
       ELSE
         WRITE(6,*) ' ASR =',ASR
       ENDIF 
       CALL VINIT(1,RUNIT,VUNIT)
       CALL VINIT(2,RUNIT,VUNIT)
       FIRST=.FALSE.
      ENDIF
C
C     NV = 0 INDICATES POTENTIAL TO BE USED WITHOUT FURTHER VARIATION
C
      IF(NV.EQ.0) RETURN
C
C     JUST ONE PARAMETER CAN BE FITTED WITH SCALAM
C
      IF(IVAR.EQ.1) THEN
        RSR(NV)=SCALAM
      ELSEIF(IVAR.EQ.2) THEN
        NSR(NV)=SCALAM
      ELSEIF(IVAR.EQ.3) THEN
        BSR(NV)=SCALAM
      ELSEIF(IVAR.EQ.4) THEN
        RLR(NV)=SCALAM
      ELSEIF(IVAR.EQ.5) THEN
        AEX=SCALAM
      ELSEIF(IVAR.EQ.6) THEN
        C6=SCALAM
      ELSEIF(IVAR.EQ.8) THEN
        C8=SCALAM
      ELSEIF(IVAR.EQ.10) THEN
        C10=SCALAM
      ENDIF
      CALL VINIT(NV,RUNIT,VUNIT)
C     AEX, C6 C8, C10 AFFECT BOTH POTENTIALS
      IF (IVAR.GE.5) CALL VINIT(3-NV,RUNIT,VUNIT)
      RETURN
      END
