from __future__ import division
import numpy as np
from numpy import pi
import sys, os
import matplotlib
matplotlib.use('Agg')
from matplotlib import ticker
from matplotlib import rc
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
plt.rc('text', usetex=True)
plt.rc('font', family='serif',serif='Times',size=48)
figsize=(20,8)

folder='vw'
for f in os.listdir(folder):
    if not f=='fig.png':
        exec('%s=np.loadtxt(folder+"/"+f)'%(f[:-4]))

Ts=Ts[1:,:]
Tds=Tds[1:,:]
alphas=alphas[1:]

def rm_fit(alpha):
    return np.sinh(alpha*pi**3/16)**2/(np.sinh(alpha*pi**3/16)**(2)+np.cosh((pi/2)*np.sqrt((pi/2)**2-1))**2)

fig=plt.figure(figsize=figsize)
msize=130
lwidth=3
widths=[20,1,20]
heights=[2,20,1]
gspec=gridspec.GridSpec(ncols=3,nrows=3,width_ratios=widths,height_ratios=heights)
ax1=fig.add_subplot(gspec[1,0])
ax2=fig.add_subplot(gspec[1,2])
colours=['blue','red','green','magenta','gray','orange']
markers=['P','v','s','x','D','1','.','p','*']
labels=[]
for i in range(len(ws)):
    labels.append('$w=%3.2f$'%ws[i])
    ax1.scatter(alphas,Ts[:,i],s=msize,marker=markers[i])
    ax2.scatter(alphas,Tds[:,i],s=msize,marker=markers[i])
ax1.set_xlabel('$\\alpha$',fontsize=54,labelpad=10)
ax2.set_xlabel('$\\alpha$',fontsize=54,labelpad=10)
ax1.set_ylabel('$T_{h}$',rotation=90,labelpad=10,fontsize=54)
ax2.set_ylabel('$T_{\\delta}$',rotation=90,labelpad=10,fontsize=54)
ax1.set_ylim(0,1.02)
ax2.set_ylim(0,1.02)
ax1.set_xlim(0.2,3.1)
ax2.set_xlim(0.2,5.1)
ax1.xaxis.set_ticks([1,2,3])
ax2.xaxis.set_ticks([1,3,5])
lgnd=fig.legend(labels,loc='upper left',ncol=len(ws),fontsize=48,markerscale=2,labelspacing=0,handletextpad=0.6,columnspacing=1.0,handlelength=0.1)
labels2=['Rosen-Morse Analysis','$\\delta$-function Analysis']
lrm=ax1.plot(alphas,rm_fit(alphas),color='black',linestyle='--',linewidth=lwidth,label=labels2[0])
ld=ax2.plot(alphas,alphas**2/(1+alphas**2),color='black',linestyle='--',linewidth=lwidth,label=labels2[1])
letters=['a','b']
positiony,positionxs=0.68,[0.14,0.58]
for i in range(2):
    positionx=positionxs[i]
    fig.text(positionx,positiony,'(%s)'%letters[i],fontsize=48)
    exec("ax%d.tick_params(length=6,width=2)"%(i+1))
    
plt.savefig('fig_2.eps')
