set terminal postscript portrait color enhanced  "Times-Roman, 19"

set output "DiffusiveBallisticSolitonWeissEtAl2015Fig2.ps"

set size 1.2,0.795

set multiplot

# set size 0.6,0.3 


set size 1.23,0.4



set origin 0.00,0.4

set xtics font "Times-Roman"

set ytics font "Times-Roman"

set ylabel "{/Times-Italic  N , (N_0-N)}"

set xlabel "{/Times-Italic t}  {/Times (s)}"


set nokey

#set ytics 0,2500,5000



#set xtics 0, 0.5, 1

#tcorrect = 1.421967662

set label "{/Times (a)}" at 0.0007,1000

set format x "10^{%T}"
set format y "10^{%T}"
set logscale y

set logscale x
set xtics 0.0000001, 10, 10
#set ytics 0.01, 10, 10000



plot[0.0001:10][0.1:10000]  "balldiffPRALiENS12.dat" u 6:2 with lines lw 4 lt 1 lc rgb "black", "MapleNt.dat" u 1:(6000.0-($2)) with lines lw 9 lt 1  lc rgb "yellow",  "balldiffPRALiENS12.dat" u 6:((6000.0-($2))) with lines lw 4 lt 2 lc rgb "black"


#unset logscale x
#set xtics 0, 0.5, 1

unset label

#set ytics 0,1,3000



set ylabel "{/Times-Italic  {/Symbol x / x_{N_0}}}"



set nolabel

set origin 0.0,0.26

#set label "{/Times island}" at -0.5,-1




#set label "{/Times electrode}" at 6.2,-1

#set ylabel "{/Times-Italic k}_{/Times B}{/Times-Italic T_{1,2} / E}_{gap}"

set ylabel " {/Symbol D}{/Times-Italic x} / {/Symbol x_{/Times-Italic N_0}}"
#set nologscale x

#set ytics -10,0.2,10

#set xtics -10,1,10

#unset ytics

set logscale x
set logscale y


unset label

set label "{/Times (b)}" at 0.0007,80

set origin 0,-0.004

plot[0.0001:10][0.01:1000]   "balldiffPRALiENS12.dat" u  6:5 with lines lw 6 lc rgb "blue",  "balldiffPRALiENS12_0.dat" u  6:5 with lines lw 6 lc rgb "black", (20*x**(0.5)) with lines lt 2 lc rgb "magenta" lw 4, 17*x with lines lt 4 lc rgb "green" lw 4



















