set terminal postscript portrait color enhanced  "Times-Roman, 19"

set output "DiffusiveBallisticSolitonWeissEtAl2015FigAppendix.ps"

set size 1.172,0.3

set multiplot


set size 0.61,0.33




set origin 0.6,-00.03

set xtics font "Times-Roman"

set ytics font "Times-Roman"

set ylabel "<E>(t) / <E>(0)"


#set xlabel "{/Times-Italic t }  {/Times (s)}"
set xlabel "{/Times-Italic t } / {/Symbol t}_{/Times loss}"

set nokey







set label "{/Times (b)}" at 0.0005,20

set format x "10^{%T}"
set format y "10^{%T}"
set logscale y

set logscale x
set xtics 0.00000001, 100, 100
set ytics 0.01, 10, 10000

plot[0.0001:10.0][0.1:100]  "balldiffPRALiENS2NBnewEnergy.dat" u  7:9 with lines lw 4 lc rgb "red", "balldiffPRALiENS2NAnewEnergy.dat" u  7:9 with lines lw 4 lc rgb "black", "balldiffPRALiENS12.dat"  u  7:9 with lines lw 4 lc rgb "blue", "balldiffPRALiENS9newEnergy.dat"  u  7:9 with lines lw 4 lc rgb "#00FFFF", "balldiffPRALiENS8.dat"  u  7:9 with lines lw 4 lc rgb "brown",  2.415542584 with lines lw 10 lt 4 lc rgb "blue"



#, 10*x**0.5 with lines lw 2 lc rgb "magenta", 200.0*x with lines lw 2 lc rgb "green"





#, "balldiffpaperLiENSMoreErr.dat" u  (($1)/471000.0):5 with lines lt 1 lw 4 lc rgb "red"




#unset logscale x
#set xtics 0, 0.5, 1

#unset label









set nolabel

set size 0.61,0.33

set origin 0.0,-0.03
#set origin 0.6,-00.03

#set label "{/Times island}" at -0.5,-1




set ylabel "{/Symbol D}{/Times-Italic x} / {/Symbol x_{/Times-Italic N_0}}"
#set nologscale x


set label "{/Times (a)}" at  0.003,20

set xtics 0.00000001, 100, 100

set format y "10^{%T}"

set xlabel "{/Times-Italic t } / {/Symbol t}_{/Times loss}"


plot[0.0001:100][0.1:100] "balldiffPRALiENS2NB.dat" u  7:5 with lines lw 4 lc rgb "red", "balldiffPRALiENS2NA.dat" u  7:5 with lines lw 4 lc rgb "black", 0.4*x**0.5 with lines lw 2 lc rgb "magenta", 0.3*x with lines lw 2 lc rgb "green"






