
function final = relaxfunc(paras, tscale, verbose)

global NEA NLOGTAU0 ND NTHETA R RELOBJ;

if nargin<3
    verbose=RELOBJ.verbose;
end

Tsteps=length(tscale);
final=zeros(1,Tsteps);

Ea=paras(NEA);
tau0=10^paras(NLOGTAU0);

if RELOBJ.problemtype==ProblemType.NRME
    CCdist=paras(ND);
    CHdist=1.08;
    coneangle=70.56;
    CHrdist=sqrt(CHdist^2 + CCdist^2 - 2*CCdist*CHdist*cosd(coneangle)); % use cosine rule to work out CHrdist
    RELOBJ.wCoupling=2*pi*rtod(CHrdist,'1H','13C');
    sinTHETA=(CHdist/CHrdist)*sind(coneangle);
    if sinTHETA>1
          error('sin(theta) out of range');
    end
    RELOBJ.theta=asind(sinTHETA);
else
    RELOBJ.wCoupling=2*pi*paras(ND);
    RELOBJ.theta=paras(NTHETA);
end

%RELOBJ.updateconstant();

for tstep=1:Tsteps
    TK=tscale(tstep)+273.15;
    tauc=tau0*exp(Ea/(R*TK));
    if tstep==1
         RELOBJ.initialise(tauc);
    end
    D=1/tauc;
    if verbose>0
        fprintf('T=%g C  tau_c = %g x 10^-11 s  jump rate: %g MHz\n',tscale(tstep),tauc*1e11,D*1e-6);
    end
    %if RELOBJ.isQrelaxation~=0
    %    G=calcQgs(D,RELOBJ.cons,RELOBJ.vH,verbose);
    %else
    %    G=calcgs(D,RELOBJ.cons,RELOBJ.vH,RELOBJ.vS,verbose);
    %end
    %final(tstep)=dot(G,lW);
    final(tstep)=RELOBJ.calcR(tauc);
end

if RELOBJ.fitR1==0
    final = 1 ./ final;
end
