function [chisqr,alpha,beta]=mqrcof(func,p,xpoints,ypoints,actord,gradv,W,figno)

if nargin<8
   figno=0;
end

totpoints=numel(ypoints);

npars=length(actord);

beta=zeros(npars,1);
%grad=zeros(npars,length(xpoints));

ytrial=feval(func,p,xpoints);

needresh=0;
if size(ytrial,1)~=1 || totpoints~=length(xpoints)
   needresh=1;
   ypoints=reshape(ypoints,1,totpoints);
   ytrial=reshape(ytrial,1,totpoints);
end
dy=ypoints-ytrial;

if figno~=0
   figure(figno);
   if needresh==0
      plot(xpoints,ypoints,'r-',xpoints,ytrial,'b-');
   else
      xscale=[1:totpoints];
      plot(xscale,ypoints,'r-',xscale,ytrial,'b-');
   end
   disp('Press key to continue...');
   pause;
end

grad=cell(1,npars);

for j=1:npars
	apar=actord(j);
	ptry=p;
	dv=1e-4*gradv(apar);
	if dv==0
		error('Cannot calculate gradient!');
	end
	ptry(apar)=p(apar)-dv;
	datam=feval(func,ptry,xpoints);
	ptry(apar)=p(apar)+dv;
   diff=feval(func,ptry,xpoints)-datam;
   if needresh
      diff=reshape(diff,1,totpoints);
   end
	grad{j}=diff/(2*dv);
end;

W2=W .* W;
if size(grad{1},1)~=size(W2,1)
    W2 = W2';
end

alpha=zeros(npars,npars);
for j=1:npars
	sgrad=(grad{j} ./ W2)'; 
	for k=j:npars
		alpha(j,k)= real(grad{k} *sgrad);
	end
	beta(j)=dy*sgrad;
end

for j=1:npars
	for k=1:j-1
		alpha(j,k)=alpha(k,j);
	end
end

chisqr=(dy ./ W2)*dy';

		

	