function [p,corcof,chisqr,steps]=gofitdata(parnames,func,p0,xpoints,ypoints,which,errors,W,maxsteps,chistop,figno)
% GOFITDATA - wrapper function for fitdata
%   See FITDATA for an explaination of the parameters. GOFITDATA is simply a wrapper
%   taking a list of parameter names as an additional argument and printing out
%   information before and after the fit
%
npars=length(p0);

disp('Starting parameters and errors');
fprintf('Name     \t Value \t Error \t Fitted?\n');
for j=1:npars
   where=find(which==j);
   switch length(where)
   case 0,
      isth='no';
   case 1,
      isth='yes';
   otherwise,
      error('Variable selected more than once');
   end
   fprintf('%s \t %d \t %d \t %s\n',parnames{j},p0(j),errors(j),isth);
end

npts=numel(ypoints);

disp(['Number of parameters: ' num2str(npars) '   Free: ' num2str(length(which))]);
disp(['Data points: ' num2str(npts)]);

if nargin==7
    W=1;
end

switch nargin
    case {7,8}
[ p, covar, chisqr, steps] =fitdata( func, p0, xpoints, ypoints, which, errors,W);
    case 9
[ p, covar, chisqr, steps] =fitdata( func, p0, xpoints, ypoints, which, errors,W,maxsteps);
                
    case 10
[ p, covar, chisqr, steps] =fitdata( func, p0, xpoints, ypoints, which, errors,W,maxsteps,chistop);
    case 11
[ p, covar, chisqr, steps] =fitdata( func, p0, xpoints, ypoints, which, errors,W,maxsteps,chistop,figno);
    otherwise
        error('gofitdata: bad number of input arguments');
end

nacpars=length(which);

fprintf('Name     \t Value    \t Error\n');
for j=1:nacpars
   actpar=which(j);
   fprintf('%s \t %g \t %g\n',parnames{actpar},p(actpar),sqrt(covar(j,j)));
end

corcof=covar;
for j=1:nacpars
   for k=j+1:nacpars
      cor=covar(j,k)/sqrt(covar(j,j)*covar(k,k));
      fprintf('%s %s correlation coefficient: %g\n',parnames{which(j)},parnames{which(k)},cor);
      corcof(j,k)=cor;
      corcof(k,j)=cor;
   end
end

if (length(W)==1) && (W~=0)
    fprintf('Noiselevel if statistical: %g\n',W*sqrt(chisqr/npts));
end
%if chisqr>npts
%   Q=gammacf( chisqr/2, npts/2);
%else
%   Q=1-gammainc( chisqr/2, npts/2);
%end

%disp(['Q value: ' num2str(Q)]);

