function gs = calcgs(D,cons,vH,vS,verbose)

if nargin==3
    verbose=1;
end

wH=2*pi*vH; % 1H Larmor frequency (angular frequency)
wS=2*pi*vS; % X Larmor frequency

gD1=gfunc(1/D,wH-wS);
gD2=gfunc(0.25/D,wH-wS);
gC1=gfunc(1/D,wS);
gC2=gfunc(0.25/D,wS);
gS1=gfunc(1/D,wH+wS);
gS2=gfunc(0.25/D,wH+wS);

gs=cons*[gD1,gD2,gC1,gC2,gS1,gS2];

if verbose~=0
    fprintf('Spectral densities at wH-wS: %g %g Hz\n',gs(1),gs(2));
    fprintf('Spectral densities at wS: %g %g Hz\n',gs(3),gs(4));
    fprintf('Spectral densities at wH+wS: %g %g Hz\n',gs(5),gs(6));
end

function res = gfunc(tau,nu)
res = tau/(1+(tau*nu)^2);
