function gs = calcQgs(D,cons,vH,verbose)

if nargin==3
    verbose=1;
end

wH=2*pi*vH; % 2H Larmor frequency (angular frequency)

g11=gfunc(1/D,wH);
g12=gfunc(0.25/D,wH);
g21=gfunc(1/D,2*wH);
g22=gfunc(0.25/D,2*wH);

gs=cons*[g11,g12,g21,g22];

if verbose~=0
    fprintf('Spectral densities at wL: %g %g Hz\n',gs(1),gs(2));
    fprintf('Spectral densities at 2*wL: %g %g Hz\n',gs(3),gs(4));
end

function res = gfunc(tau,nu)
res = tau/(1+(tau*nu)^2);
