function covar=covariance(func,p,xpoints,W,actord,gradv)
% COVAR - calculate covariance matrix for a model function fit
%
%  covar = covariance(func,p,xpoints,W,actord,gradv)
%
%  Input parameters:
%	func: name of function (quoted) of the form ytrial=func(p,xpoints)
%	   p: vector of parameters
%   xpoints: x values 
%    actord: (optional) vector of parameters to be varied (by default all)
%         W: (1.0) vector of noise standard deviation on each data point or single value applied to all. This allows chi^2 to be calculated appropriately.
%
if nargin~=6
	error('Wrong number of arguments');
end

npars=length(actord);

if length(gradv)~=length(p)
	error('Parameter and error sets differ in length');
end

npts=0;

for j=1:npars
	apar=actord(j);
	ptry=p;
	dv=1e-4*gradv(apar);
	if dv==0
        disp(gradv);
		error(['Cannot calculate gradient for parameter ' num2str(apar) ' ' num2str(j)]);
	end
	ptry(apar)=p(apar)-dv;
	datam=feval(func,ptry,xpoints);
	ptry(apar)=p(apar)+dv;
   datap=feval(func,ptry,xpoints);
   if npts==0
       npts=prod(size(datap));
       grad=zeros(npars,npts);
   end
   dataflat=reshape(datap-datam,1,npts);
	grad(j,:)=dataflat / (2*dv);
end;

if length(W)==1
	W2=(W*W)*ones(1,npts);
else
	W2=reshape(W .* W,1,prod(size(W)));
end

if length(W2)~=npts
	error('Data and weighting sets differ in length');
end

curv=zeros(npars,npars);

for j=1:npars
	sgrad=(grad(j,:) ./ W2)'; 
	for k=j:npars
		curv(j,k)= real(grad(k,:) *sgrad);
	end
end

for j=1:npars
	for k=1:j-1
		curv(j,k)=curv(k,j);
	end
end

covar=inv(curv);
