function [gs,supertotals] = formrelax(obj,D)
%function [gs,supertotals] = formrelax(D,cons,vH,vS,verbose)

vH=obj.vH;
vS=obj.vS;
cons=obj.cons;
if isempty(obj.theta)
    throw(MException('relax:noThetaSet','Jump angle theta unset'));
end
THETA=obj.theta;
JUMPMODE=obj.jumptype;
verbose=obj.verbose;

deg_to_rad=pi/180.0;
rad_to_deg=180.0/pi;

if verbose>0
        fprintf('H/D Larmor frequency: %g MHz\n',vH*1e-6);
        if obj.isQrelaxation==0
            fprintf('S Larmor frequency: %g MHz\n',vS*1e-6);
        end
        fprintf('Cone angle: %g degrees\n',THETA);
    fprintf('Diffusion / jump rate: %g MHz\n',D*1e-6);
end
if obj.powderaverage~=0
    alphasteps=obj.alphasteps;
    betasteps=obj.betasteps;
    if verbose~=0
        fprintf('Powder averaging over %i alpha_RC angles and %i beta_RC angles\n',alphasteps,betasteps);
    end
else
    alphasteps=1;
    betasteps=1;

    if verbose~=0
        fprintf('Calculating for single rotor orientation: alpha=%g, beta=%g degrees\n',alpha_RC,beta_RC);
    end
    alpha_RC=obj.alpha_RC*deg_to_rad;
    beta_RC=obj.beta_RC*deg_to_rad;
end
    
nsteps=obj.rotorsteps; % number of rotor steps

beta_RL=atan(sqrt(2));

if obj.isQrelaxation~=0
    gs=calcQgs(D,cons,vH,verbose);
else
    gs=calcgs(D,cons,vH,vS,verbose);
end

%Theta=70.56*deg_to_rad; % Me angle
Theta=THETA*deg_to_rad;

rotmRL=[ 1 0 0; 0 cos(beta_RL) -sin(beta_RL); 0 sin(beta_RL) cos(beta_RL)];
A1=sin(2*Theta)^2;
A2=sin(Theta)^4;
A3=(sin(Theta)^3)*cos(Theta);

R1list=[];
np=256; % number of data points
Ttot=10; % total time / s
dt=Ttot/np; % dwell time 
Decay=zeros(1,np);
totR1=0;
tscale=[0:np-1]*dt;
tweight=0;
supertotals=0;

for astep=1:alphasteps
    if alphasteps>1
        alpha_RC=(2*pi*(astep-1))/alphasteps;
    end
    for bstep=1:betasteps
        if betasteps>1
            beta_RC=(pi*(bstep-1))/betasteps;
            weight=sin(beta_RC);
        else
            weight=1;
        end

  %      [vCX,vCY,vCZ]=sph2cart(alpha_RC,(pi/2)-beta_RC,1.0); % vector describing Me orientation in molecular/crystal frame
        vC=[sin(beta_RC)*cos(alpha_RC);sin(beta_RC)*sin(alpha_RC);cos(beta_RC)];

        totals=0;
        
        for nr=1:nsteps
            rotorangle=(nr-1)*(2*pi)/nsteps; % rotor phase
            rotmCR=[ cos(rotorangle) sin(rotorangle) 0; -sin(rotorangle) cos(rotorangle) 0; 0 0 1];
            vR=rotmCR*vC; % vector describing Me orientation in rotor frame
            vL=rotmRL*vR; % vector describing Me orientation in lab frame
            %[phi,theta,R]=cart2sph(vL(1),vL(2),vL(3));
            phi=atan2(vL(2),vL(1));
            theta=acos(vL(3));
            %phi=(pi/2)-phi;
            if verbose>2
               fprintf('%f %f %f\n',rotorangle*rad_to_deg,theta*rad_to_deg,phi*rad_to_deg);
            end
               
            B1=sin(2*theta)^2;
            B2=sin(theta)^4;
            B3=(sin(theta)^3)*cos(theta);
            B4=cos(theta)^2+cos(2*theta)^2;
            B5=sin(theta)^2+0.25*sin(2*theta)^2;
            B6=1+6*cos(theta)^2+cos(theta)^4;
            A3B3cos3phi=A3*B3*cos(3*phi);
                            
            if obj.isQrelaxation~=0
                switch JUMPMODE
                    case JumpType.FREEROT,
                    w11=A1*B4;  
                    w12=A2*B5;
                    w21=4*A1*B5;
                    w22=A2*B6;
                    case JumpType.THREEJUMP,
                    w11=A1*B4+A2*B5-8*A3B3cos3phi;
                    w12=0;
                    w21=4*A1*B5+A2*B6+8*A3B3cos3phi;
                    w22=0;
                    case JumpType.TWOJUMP,
                        cos2phi=cos(2*phi);
                        w11=A1*(B4-(0.75*B1-B2)*cos2phi);
                        w12=0;
                        w21=4*A1*(B5-B1*cos2phi);
                        w22=0;
                    otherwise,
                        error('Unknown jump mode');
                end
                if verbose>2
                   fprintf('wL terms: %g and %g\n',w11,w12);
                   fprintf('2*wL terms: %g and %g\n',w21,w22);
                end
                wS=[w11,w12,w21,w22];
            else
       
                switch JUMPMODE
                    case JumpType.FREEROT,
                wD1=A1*B1;
                wD2=A2*B2;               
                wH1=2*A1*B4;
                wH2=2*A2*B5;
                wS1=4*A1*B5;
                wS2=A2*B6;
                    case JumpType.THREEJUMP,
                wD1=A1*B1+A2*B2+8*A3B3cos3phi;
                wD2=0;
                wH1=2*A1*B4+2*A2*B5-16*A3B3cos3phi;
                wH2=0;
                wS1=4*A1*B5+A2*B6+8*A3B3cos3phi;
                wS2=0;
                    otherwise,
                        error('Unimplemented jump mode for dipolar relaxation');
            end
            if verbose>2
                fprintf('wH-wC terms: %g and %g\n',wD1,wD2);
                fprintf('wC terms: %g and %g\n',wH1,wH2);
                fprintf('wH+wC terms: %g and %g\n',wS1,wS2);
              % fprintf('Ratio: 1:%g;%g\n',supertotals(3)/supertotals(1),supertotals(5)/supertotals(1));fprintf('Mean R1: %g Hz   T1: %g s\n',R1,1.0/R1);
            end
            wS=[wD1,wD2,wH1,wH2,wS1,wS2];
            end
            totals=totals+wS;
        end
        totals=totals/nsteps;
        R1=dot(gs,totals);
       if verbose>1
           if obj.isQrelaxation~=0
                   fprintf('wL terms (rotor-averaged): %g and %g\n',totals(1),totals(2));
                   fprintf('2*wL terms (rotor-averaged): %g and %g\n',totals(3),totals(4));
           else
            fprintf('wH-wC terms (rotor-averaged): %g and %g\n',totals(1),totals(2));
            fprintf('wC terms (rotor-averaged): %g and %g\n',totals(3),totals(4));
           fprintf('wH+wC terms (rotor-averaged): %g and %g\n',totals(5),totals(6));
           fprintf('Ratio: 1:%g;%g\n',totals(3)/totals(1),totals(5)/totals(1));
           end
           fprintf('Mean R1: %g Hz   T1: %g s\n',R1,1.0/R1);
       end
       supertotals=supertotals+weight*totals;
       totR1=totR1+R1*weight;
       tweight=tweight+weight;
       Decay=Decay+weight*exp(-R1*tscale);
       R1list=[R1list,R1];
    end
end
totR1=totR1/tweight;
supertotals=supertotals/tweight;
    
if obj.powderaverage~=0
    Decay=Decay/tweight;

    %superR1=dot(gs,supertotals);
    if verbose>0
        fprintf('Overall mean R1: %g Hz   T1: %g s\n',totR1,1.0/totR1);
       fprintf('Min R1: %g Hz  Max R1: %g Hz  STD R1: %g Hz\n',min(R1list),max(R1list),std(R1list));
        
       if obj.isQrelaxation~=0
               fprintf('wL terms (full averaged): %g and %g\n',supertotals(1),supertotals(2));
               fprintf('2*wL terms (full averaged): %g and %g\n',supertotals(3),supertotals(4));
       else
        fprintf('wH-wC terms (averaged): %g and %g\n',supertotals(1),supertotals(2));
        fprintf('wC terms (averaged): %g and %g\n',supertotals(3),supertotals(4));
        fprintf('wH+wC terms (rotor-averaged): %g and %g\n',supertotals(5),supertotals(6));
        fprintf('Ratio: 1:%g;%g\n',supertotals(3)/supertotals(1),supertotals(5)/supertotals(1));
       end
        meanDecay=exp(-totR1*tscale);
        plot(tscale,Decay,'bx',tscale,meanDecay,'r-');    
        xlabel('time / s'); 
        title(sprintf('Diffusion/jump rate = %g MHz',D*1e-6));
    end
end
