
% Analyses 13C T1 relaxation data from 2FS-INA
% using methodology described in Apperley et el, PCCP *15* (2013) 6422

clear;
clf;

%% Import the data
[~, ~, raw] = xlsread('FSA13CT1_errors.xlsx','Sheet1','A3:K14');

%% Replace non-numeric cells with 0.0

nfitdata=4;

names={'C44','C45','C102/103','C101','C43'};
R = cellfun(@(x) (~isnumeric(x) && ~islogical(x)) || isnan(x),raw); % Find non-numeric cells
raw(R) = {0.0}; % Replace non-numeric cells
data = reshape([raw{:}],size(raw));
fitdata=data(:,[4:2:2*nfitdata+2]);
fiterrors=data(:,[5:2:2*nfitdata+3]);

order=[1,5,2,4,3]; % re-arrange to logical order (C44 remains 1st, but unfitted)
names=names(order);
fitdata=fitdata(:,order(2:5)-1);
fiterrors=fiterrors(:,order(2:5)-1);

cols='rgbrm';
symbs='osdx+';
styles='---::';

Tcorr0=10;
fprintf('Temperature correction: %g C\n',Tcorr0);

tempsC=data(:,1)-273+Tcorr0;
tempsK=tempsC+273.15;
fitcols=1:4;
haveerrors=1;
rescaleerrs=1;




%% Import the data
%[~, ~, raw] = xlsread('\\CHEM-FS\Chemistry\SSNMR-PH\dch0ph\data\People\Hannah\FS-INA 13C T1.xlsx','T1T2module','A2:M8');
%raw(cellfun(@(x) ~isempty(x) && isnumeric(x) && isnan(x),raw)) = {''};
%cellVectors = raw(:,1);
%raw = raw(:,2:13);

%% Create output variable
%data = reshape([raw{:}],size(raw));
%tempsC=data(1,:);
%tempsK=tempsC+273.15;
%fitrows=[2:6];

tminK=min(tempsK);
tmaxK=max(tempsK);

global RELOBJ NEA NTHETA NLOGTAU0

constants;
RelaxationProblem.initialisefit();
RELOBJ=RelaxationProblem(ProblemType.NCH,JumpType.FREEROT);
RELOBJ.vH=499.7e6; % 1H Larmor freqency
RELOBJ.vS=(100.577/400)*RELOBJ.vH; % 13C Larmor frequency
RELOBJ.fitR1=0; % fitting T1 values
RELOBJ.verbose=0; % suppress plots etc.
thetaguess=20.0;

npts=40;
tscaleK=tminK+(tmaxK-tminK)*[0:npts-1]/(npts-1);
tscaleC=tscaleK-273.15;
itscale=1e3 ./ tscaleK;
eitscale = 1e3 ./ tempsK;

%if RELOBJ.fitR1~=0
%    datascale=1;
%else
%    datascale=1e3;
%end
datascale=1; 

which = [NEA,NLOGTAU0,NTHETA];
results=zeros(length(fitcols),2*length(which));
noiselevel= 0;

%for fitrowind=1:length(fitrows)
%    fitrow=fitrows(fitrowind);

%redinds=[2:size(data,1)-1];
%errorbar(tempsC(redinds),datascale*data(redinds,2),datascale*data(redinds,3),'cd');
%hold on;

for fitind=1:length(fitcols)
    ypoints=fitdata(:,fitind)';
    if haveerrors~=0
        noiselevel=fiterrors(:,fitind);
    end
        
    errors=fiterrors(:,fitind)';
    %ypoints=data(fitrow,:);
    col=cols(fitind+1);
    
    paras=[ 30.0e3 -15.0 23e3 thetaguess];
    errors=[ 0.2e3 0.2 1e3 2];  % estimated errors
    
    %cellVectors{fitrow};
    fprintf('Fitting %s data\n',names{fitind+1});
    %initial=relaxfunc(paras,tscaleC,1);
    %plot(eitscale,ypoints,'bx',itscale,initial,'r-');
    [fitparas,corcof,chisqr] =RELOBJ.fitdata( paras, tempsC, ypoints, which, errors,noiselevel);
    if rescaleerrs
        errscale=sqrt(chisqr/length(ypoints));
    else
        errscale=1;
    end
    for j=1:length(which)
        results(fitind,2*j-1)=fitparas(which(j));
        results(fitind,2*j)=errscale*sqrt(corcof(j,j));
    end

    fitted=relaxfunc(fitparas,tscaleC);

    plot(tscaleC,datascale*fitted,[col styles(fitind+1)]);
    hold on;
 
    overall=[col symbs(fitind+1)];
    if (length(noiselevel)>1)
        errorbar(tempsC,datascale*ypoints,datascale*noiselevel,overall);
    else
        plot(tempsC,datascale*ypoints,overall);
    end
    
end

xlabel('T / C');
ylabel('T_1 / s');
legstrings=cell(1,2*length(fitcols));
%legstrings{1}=names{1};
for j=1:length(fitcols)
    legstrings{2*j-1}='';
    legstrings{2*j}=names{j+1};
end
legend(legstrings);
legend('boxoff');

save('allCT1errorsN.txt','results','-ascii'); 