
% Fit 2H T1 data for 2FS-INA contained in FS_INA_2HT1.txt
% Note that code is adapted from previous relaxation analyses
% and contains so contains some unnecessary sections

clear;
constants;

plotinvT=0;

%global NEA NLOGTAU0 ND NTHETA;
global RELOBJ;
%W VH VS R THETA NME N2H NCU NDTWO NRME JUMPMODE FREEROT THREEJUMP TWOJUMP FITR1;

R=BOLTZ*NA;

% uniform offset of +8 K from MAS
% default no T correction
Tcorr0=0;
Tcorr1=0;

%ZeroT=90;
%M90Corr=+15;
%Tcorr1=-M90Corr/(90+ZeroT);
%Tcorr0=ZeroT*M90Corr/(90+ZeroT);

RelaxationProblem.initialisefit();
%NME=1; N2H=2; NCU=3; NRME=4; NDTWO=5;
%FREEROT=1; THREEJUMP=2; TWOJUMP=3;

%MODE=NDTWO;
MODE=ProblemType.NDTWO;

%W=0;

switch MODE
    case ProblemType.NME; case ProblemType.NRME;
    npeaks=2;
    otherwise
    npeaks=1;
end

figno=1;
figure(figno);
clf;

NFG=1; NCLW=2; 
%npars=4;

%NEA=1; NLOGTAU0=2; ND=3; NTHETA=4;

%parnames=cell(1,npars);
%parnames{NEA}='Activation energy';
%parnames{NLOGTAU0}='log_10(tau_0)';
%parnames{ND}='Coupling / distance';
%parnames{NTHETA}='Cone angle';

for peak=1:npeaks

    if peak==1
        col='r';
    else
        col='b';
    end
    peakname='';
 
    % which paras to fit
    which=[1:3];
%which=[1:2,4];

switch MODE
    case ProblemType.NDTWO
    load FS_INA_2HT1.txt;
    alldata=FS_INA_2HT1;
    tscale=alldata(:,1)'; 
    noiselevel=1e-3*alldata(:,3)';
    noiselevel=mean(noiselevel);
    fprintf('Using mean noise level: %g ms\n',noiselevel*1e3);
    
%    ypoints=1 ./ (1e-3*alldata(:,2)'); % data in ms
    ypoints=1e-3*alldata(:,2)'; % data in ms
    
    Tcorr0=15; % 4 mm probe, 10 kHz MAS
    Ea=15e3;
    logtau0=-11.8;
    RELOBJ=RelaxationProblem(MODE, JumpType.TWOJUMP);
    theta=15;
    RELOBJ.fitR1=0;

%    wQ=Cq*(2*pi);
%    cons=wQ*wQ/8;
    RELOBJ.vH=76.8e6; %2H frequency @ 500 MHz
    peakname='2-jump model';
    which=[1,2,4];
    paras=[ Ea logtau0 222e3 theta];
    
    case ProblemType.N2H
    VH=61.40e6;
    THETA=15.0;
    load exptD;
    [sorted,index]=sort(exptD(:,1));
    exptD=exptD(index,:);
    tscale=(1e3 ./ exptD(:,1))-273.15;
    ypoints=exptD(:,2)';
    noiselevel=exptD(:,3)';

    Ea=33e3;
    logtau0=log10(8.9e-15);
    peakname='2-jump model';
    JUMPMODE=JumpType.FREEROT;
    which=[1,2,4];
    paras=[ Ea logtau0 168e3 THETA];
      
    case {ProblemType.NME, ProblemType.NRME}
    VH=400e6; % 1H Larmor frequency
    VS=(100.577/400)*VH;
    THETA=70.56;
    JUMPMODE=JumpType.THREEJUMP;
 %   load exptme;
    load fitt1res;
    if peak==1
        peakname='O-methyl';
        col='r';
    else
        peakname='h methyl';
        col='b';
    end
    ypoints=1 ./ fitted(peak,:);
    Ea=14.4e3;
    logtau0=-12.4;
    if MODE==ProblemType.NME
        dpar=20e3; % D_CH coupling / Hz
    else
        dpar=2.5; % distance between carbons /A 
    end
    paras=[ 17.4e3 -12.4 dpar THETA];
    %noiselevel=0.1*max(ypoints);
    noiselevel= fiterror(peak,:) .* (ypoints .* ypoints);
    
    case ProblemType.NCU
     VH=400e6; % 1H Larmor frequency
    VS=(100.577/400)*VH;
    load fitt1resu;
    peakname='C_u';
    ypoints=1 ./ fitted(peak,:);
    JUMPMODE=JumpType.FREEROT;
 
    paras=[ 39.0 -13.9 23e3 THETA];
    which = [1,2];
    noiselevel= 0.01;
    %fiterror(peak,:) .* (ypoints .* ypoints);
   
    otherwise
        error('Unsupported mode');
end

errors=[ 0.2e3 0.2 1e3 2];  % estimated errors

tscale_corr=(1+Tcorr1)*tscale + Tcorr0;

maxt=max(tscale_corr);
mint=min(tscale_corr);
stscale=[mint:(maxt-mint)/50:maxt];
sitscale=1e3 ./ (273.15+stscale);

eitscale=1e3 ./ (273.15+tscale_corr);
%initial=relaxfunc(paras,tscale_corr,1);
%plot(eitscale,ypoints,'bx',eitscale,initial,'r-');

fprintf('Fitting %s data\n',peakname);
fprintf('Using temperature corrections: %g K (zero order), %g (first order)\n',Tcorr0,Tcorr1);
%if length(find(which==NTHETA))~=0
%    W=0;
%else
%    [G,W]=formrelax(100e3,100e3,VH,VS,0);
%end

%[ fitparas, covar, chisqr, steps] =gofitdata( parnames,'relaxfunc', paras, tscale_corr, ypoints, which, errors,noiselevel,50,0.2,0);
[ fitparas, covar, chisqr, steps] =RELOBJ.fitdata( paras, tscale_corr, ypoints, which, errors,noiselevel);

fitted=relaxfunc(fitparas,stscale);
%diffspec=ypoints-spectrum;
figure(figno);
hold on;
if plotinvT~=0
    plotsscale=sitscale;
    plotescale=eitscale;
else
    plotsscale=stscale;
    plotescale=tscale_corr;
end
if RELOBJ.fitR1~=0
    datascale=1;
else
    datascale=1e3;
end
plot(plotsscale,datascale*fitted,[col '-']);
if (length(noiselevel)>1)
    errorbar(plotescale,datascale*ypoints,noiselevel,[col 'x']);
else
    plot(plotescale,datascale*ypoints,[col 'x']);
end

if MODE==ProblemType.N2H
    MODE=ProblemType.NME;
    JUMPMODE=JumpType.FREEROT;
    VH=400e6; % 1H Larmor frequency
    VS=(61.402/400)*VH;
    D=20e3*(61.402/100.577);
    hmethylparas=[ 15.5e3 -12.6 D 70.56];
   [G,W]=formrelax(100e3,100e3,VH,VS,0);
     
    methylmodel=relaxfunc(hmethylparas,stscale);
    plot(plotscale,methylmodel,'b-');
end

%xscale,diffspec,'c-');

if plotinvT~=0
    xlabel('10^3 K / T');
else
    xlabel('T / ^{\circ}C');
    axis([-65 45 6 24]);
end
if RELOBJ.fitR1==0
    ylabel('T_1 / ms');
else
  ylabel('R_1 / s^-1');
end

   Ea=fitparas(1);
   tau0=10^fitparas(2);
   Tcheck=298;
   tauc=tau0*exp(Ea/(R*Tcheck));
   taucm60=tau0*exp(Ea/(R*(-60+273.15)));
   fprintf('At %g K:  tau_c = %g x 10^-11 s  jump rate: %g MHz\n',Tcheck,tauc*1e11,(1/tauc)*1e-6);
   fprintf('At -60 C:  tau_c = %g x 10^-11 s  jump rate: %g MHz\n',taucm60*1e11,(1/taucm60)*1e-6);
   
end
