classdef ProblemType
    %ProblemType Specifies relaxation model
% N2H - quadrupolar relaxation of 2H
% N2HD - relaxation of 2H by remote protons
% NCH - relaxation of CH (e.g. Cu of fumarate) by attached 1 x H (dipolar)
% NME - relaxation of methyl C by methyl rotational diffusion
% NDTWO - quadrupolar relaxation of 2H (sulphonamide)

    enumeration
        NME, N2H, NCH, N2HD, NDTWO, NRME
    end
end
