# Copyright (C) 2015 Matthias C. M. Troffaes
# matthias.troffaes@durham.ac.uk
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Counting number of extreme points."""

import itertools
import logistic_prior

def get_num_extremes(numregr, numcats):
   xs_prior = list(itertools.product([1], *itertools.repeat([0,1], numregr)))
   return sum(1 for i in logistic_prior.get_t_prior_extremes(xs_prior, 2, numcats))

for numcats, numregr in itertools.product([2,3,4,5], [2,3,4,5]):
    #print numregr, numcats, get_num_extremes(numregr, numcats)
    print numregr, numcats, numcats ** (2 ** numregr)
