# Copyright (C) 2015 Matthias C. M. Troffaes & Lewis Paton
# matthias.troffaes@durham.ac.uk, l.w.paton@durham.ac.uk
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import matplotlib.pyplot as plt
import numpy as np
from scipy.stats import multivariate_normal
import smooth

obs_agresti = [
    [(1,1.24),2],
    [(1,1.30),2],
    [(1,1.30),2],
    [(1,1.32),1],
    [(1,1.32),1],
    [(1,1.40),1],
    [(1,1.42),2],
    [(1,1.42),1],
    [(1,1.45),2],
    [(1,1.45),3],
    [(1,1.47),2],
    [(1,1.47),1],
    [(1,1.50),2],
    [(1,1.52),2],
    [(1,1.55),2],
    [(1,1.60),2],
    [(1,1.63),2],
    [(1,1.65),3],
    [(1,1.65),2],
    [(1,1.65),1],
    [(1,1.65),1],
    [(1,1.68),1],
    [(1,1.70),2],
    [(1,1.73),3],
    [(1,1.78),2],
    [(1,1.78),2],
    [(1,1.78),3],
    [(1,1.80),2],
    [(1,1.80),1],
    [(1,1.85),1],
    [(1,1.88),2],
    [(1,1.93),2],
    [(1,1.98),2],
    [(1,2.03),1],
    [(1,2.03),1],
    [(1,2.16),1],
    [(1,2.26),1],
    [(1,2.31),1],
    [(1,2.31),1],
    [(1,2.36),1],
    [(1,2.36),1],
    [(1,2.39),1],
    [(1,2.41),1],
    [(1,2.44),1],
    [(1,2.46),1],
    [(1,2.56),3],
    [(1,2.67),2],
    [(1,2.72),2],
    [(1,2.79),1],
    [(1,2.84),1],
    [(1,3.25),3],
    [(1,3.28),3],
    [(1,3.33),3],
    [(1,3.56),1],
    [(1,3.58),1],
    [(1,3.66),1],
    [(1,3.68),3],
    [(1,3.71),1],
    [(1,3.89),1]
    ]

def plot():
    for j in [1,2,3]:
        k = smooth.get_gaussian_kernel(np.array([1, 0.5]))
        s = smooth.get_smoother(obs_agresti, k, j)
        xs = np.linspace(0, 5)
        ys = [s(np.array([1, x])) for x in xs]
        plt.plot(xs, ys)
    plt.show()

def test_scipy():
    np.testing.assert_almost_equal(
        multivariate_normal(mean=[1,2,3], cov=np.diag([1,2,3])).pdf(
            [1.5, 2.1, 2.7]),
        0.0224785145646)

def test_smoother():
    a = lambda x: np.array([x])
    kern = smooth.get_gaussian_kernel(a(1))
    np.testing.assert_almost_equal(
        smooth.get_smoother([(a(0),0), (a(1),1)], kern, 0)(a(0.2)),
        0.574442516812)
    np.testing.assert_almost_equal(
        smooth.get_smoother([(a(0),0), (a(1),1)], kern, 1)(a(0.2)),
        0.425557483188)
    np.testing.assert_almost_equal(
        smooth.get_density([(a(0),0), (a(1),1)], kern)(a(0.2)),
        1.70634771038)
