;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; slit_ap_cross.pro
; 
; more work on slit apertures - but this time to simulate images
; of crosses
; 
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

npix = 2^12       ; number of pixels in SLM
nzern=20                  ; number of Zernike modes
bu =2             ; oversampling factor
amp_zern=fltarr(nzern+1)  ; array of Zernike amplitudes
lambda = 550e-9
theta =0

d_max = 1.5e-3
d_min = 12.0e-3
area = !pi * d_max * d_min /4

;d_max = sqrt(area * 4 /!pi)
;d_min = d_max

diop = fltarr(3)
diop(0) = 0
;diop(1) = 1.3
;diop(2) = 1.8
diop(1) = 0.4
diop(2) = 0.8

zero_distance = 0.333

distance = fltarr(3)
distance = 1.0/(1.0/zero_distance - diop) 
print, 'distance = ', distance




npt = npix*bu
hnpt=npt/2
image = fltarr(npt,npt)
object = fltarr(3,npt,npt)
image_array = fltarr(3,npt,npt)
mask = replicate(1.0,npt, npt)

 
for loop = 0,2 do begin
print, 'beginning of loop ', loop


length = floor( 0.6 * float(npt))
length = length * distance(0)/distance(loop)

print, 'Length = ', length

if d_max gt d_min then begin
 print, 'Pixel size   ', ( 550e-9/(bu* d_max)) *180.0/!pi*60, ' arcmins'
 print, 'Field of view   ', (float(npt) * 550e-9/(bu* d_max)) *180.0/!pi, '  degrees'
endif else begin
 print, 'Pixel size   ', ( 550e-9/(bu* d_min)) *180.0/!pi*60, ' arcmins'
 print, 'Field of view   ', (float(npt) * 550e-9/(bu* d_min)) *180.0/!pi, '  degrees'
endelse

spacex = floor(npt/6.0)*1.0/(1+sqrt(float(loop)))
spacey = floor(npt/8.0)*1.0/(1+sqrt(float(loop)))
width = 100 * distance(0)/distance(loop)
xcentre=npt/3+float(loop)*spacex
ycentre=npt/3+float(loop)*spacey

for k=0, width-1 do begin
 object(loop, xcentre-length/2: xcentre+length/2, ycentre+k) = 1
 object(loop, xcentre+k, ycentre-length/2: ycentre+length/2) = 1
endfor



print, ' defined the object'

;area = !pi * d_max * d_min /4
;d_max = 2* sqrt(area/!Pi)
;d_min = d_max
print, 'D Max = ', d_max, ' D_min = ', d_min



r_max = d_max/2
r_min = d_min/2

if d_max gt d_min then d_maxx=d_max else d_maxx = d_min

pupil = fltarr(npix,npix)
major = r_max
minor = r_min
for j=0, npix-1 do begin
 for i=0, npix-1 do begin
  x = float(i-npix/2)/(npix/2)*d_maxx/2
  y = float(j-npix/2)/(npix/2)*d_maxx/2
  ; use equations x^2 / a^2  + y^2 / b^2 = 1
  r = x^2/major^2 + y^2/minor^2 
  if r le 1.0 then pupil(i,j) = 1.0
 endfor
endfor


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; how to convert from dioptres to Zernike amplitudes
; RMS = D r^2 / (4 sqrt(3))

if r_max ge r_min then begin
 rms = diop(loop)*r_max^2 / (4.0*sqrt(3))
endif else begin
 rms = diop(loop)*r_min^2 / (4.0*sqrt(3))
endelse

amp_zern(4) = rms / lambda

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; generate zernike modes and phase map
;

  phase=fltarr(npix,npix)

  ; Convert Zernike index into quantum numbers
  for nz=1,nzern-1 do begin
   csum=fltarr(nz+1)
   for i=1,nz do begin

     csum(i) = total(indgen(i)+1)
   endfor
   nindx = fix(total(csum lt nz))
   mx = csum(nindx-1)
   n=nindx-1
   m = nz - mx - 1;
   if float(n-m)/2 eq round(n-m)/2 then begin
    even = 1
    endif else begin
      even = 0
      m = m + 1
    endelse
   phase = phase + 2*!pi*amp_zern(nz)*zern_gen(npix,n,m,even)
;   print,' nz = ', nz,  '      n = ', n, ' m = ', m, '  even = ', even
   endfor
   phase = phase*pupil
;;;; Here the Zernikes are defined st their rms error is 1 radian for 1 unit of
;;;; applied amplitude

print, 'phase defined'

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Generate padded wavefront

   big_pupil = fltarr(npt, npt)
   big_phase = fltarr(npt, npt)
   big_pupil(hnpt-npix/2:hnpt+npix/2-1,hnpt-npix/2:hnpt+npix/2-1) = pupil
   big_phase(hnpt-npix/2:hnpt+npix/2-1,hnpt-npix/2:hnpt+npix/2-1) = phase


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;; Calculate Diffraction Pattern
   ch  = checker(npt)
   complex_pupil = complexarr(npt, npt)
   complex_image = complexarr(npt, npt)
   complex_pupil = big_pupil*exp(complex(0.0, big_phase+ch))
   complex_image = fft(complex_pupil, -1)
   psf = (abs(complex_image))^2

print, 'psf defined'

np=256
window, 1, xsize=2*np, ysize=np
tvscl, rebin(psf, np,np)
tvscl, rebin(phase, np,np), np, 0

; screen=tvrd( true=1)
; write_bmp,'C:\Documents and Settings\gdl\My Documents\output.bmp', screen, rgb=1



sub_object=fltarr(npt,npt)
for j=0, npt-1 do begin
 for i=0, npt-1 do begin
   sub_object(i,j)=object(loop,i,j)
 endfor
endfor



sub_image = convolve(sub_object, psf)
image_array(loop,*,*) = sub_image
if loop ge 1 then begin
 sub_mask = image_array(loop-1,*,*)
 sub_mask = max(sub_mask)-sub_mask
 sub_mask = sub_mask / max(sub_mask)
 mask = mask*sub_mask
 sub_image = sub_image * mask
endif

image = image + sub_image

print, ' image defined'
;set_plot, 'ps'
 fn='cross_horiz.eps'
; DEVICE, /helvetica, FILENAME=fn, /COLOR, /ENCAPSULATED
xp = 512
loadct, 0
window, 0, xsize =xp, ysize = xp, retain =2
tvscl, rebin(image, xp, xp)
print, 'data plotted'
;tvscl, image
output2 = tvrd()
print, 'output recorded'


;set_plot, 'x'
endfor

set_plot, 'ps'
fn = 'cross_vert_0.4_0.8_12.0_1.5.eps'
Device, FILENAME=fn
tvscl, output2
set_plot, 'x'


end









