;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;
; slit_ap.pro
;
; Programme to simulate PSFs from animals with slit pupils
;
;; the _mk modification, Durham 24/4/12
; added to simulate eyes with different zones as in the 
; Malmstrom and Kruger

;
; Gordon Love, Innsbruck,  13/03/12
; 
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;
;encircled energy
function en_en, psf
size_of_psf = size(psf)
maxpsf  = max(psf)
npt_base = size_of_psf(2)

threshold = maxpsf*1e-3
energy = fltarr(101)
xrange = npt_base
yrange = npt_base
for k = 0, 100 do begin
total_energy = 0
 for j= npt_base/2-yrange/2, npt_base/2+yrange/2-1 do begin
  for i= npt_base/2-xrange/2, npt_base/2+xrange/2-1 do begin
   if psf(0,i,j) gt threshold then begin
   r = sqrt(float(i-npt_base/2)^2 + float(j-npt_base/2)^2)
    if r le float(k) then energy(k) = energy(k) + psf(0,i,j)  
    total_energy = total_energy + psf(0,i,j)
   endif
  endfor
 endfor
energy(k) = energy(k) / total_energy * 100
endfor

print, energy
maxval = total(energy lt 80)
return, maxval
end
;goto, jump

; SET INITIAL VARIABLES

set_plot, 'x'
n_rbl = 1 ; n in the really big loop - loop over aperture sizes
d_min = fltarr(n_rbl)
d_max = fltarr(n_rbl)
area = fltarr(n_rbl)
d_maxx= 12.0e-3 ; size of the max possible radii of aperture
d_minn= 12.0e-3 ; size of the min possible radii of aperture
;for rbl = 0, n_rbl-1 do begin
loadct, 39

;print, 'Starting Loop ', rbl

npix = 256 ; 128
bu_base=2  ;2
nzerns= 11  ; number of Zernikes
nmkz = 3 ; number of MK zones
ndf = 51 ; number of defocus terms
fwhmx = fltarr(ndf) ; fwhm in x
fwhmy = fltarr(ndf) ; fwhm in y
amp_zern = fltarr(nzerns)
amp_zern(4) = 1.0
nlambda =  101;  number of wavelengths to be summed over
bu = fltarr(nlambda)
npt = intarr(nlambda)
npt_base = npix*bu_base
hnpt_base = npix*bu_base/2
mtf=fltarr(ndf,npt_base, npt_base)
lambda = fltarr(nlambda)
weight = fltarr(nlambda)
m3 = fltarr(nlambda)
z3 = fltarr(nlambda)
eeee=fltarr(3,ndf)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; the following code is for making the pupil
; area change with conserved area
;
;if rbl le n_rbl/2 then begin
; d_min(rbl) = d_minn + ((d_maxx+d_minn)/2-d_minn)*float(rbl)/float(n_rbl-1)
; area(rbl) = !pi * (d_maxx/2)*(d_minn/2)
; d_max(rbl) = area(rbl)/d_min(rbl)/!pi*4 ; max pupil size
;endif else begin
; d_max(rbl) = d_min(n_rbl-rbl-1)
; d_min(rbl) = d_max(n_rbl-rbl-1)
;endelse;;;

;if rbl le n_rbl/2 then begin
; d_max(rbl)=12.0e-3
; d_min(rbl) = 1.5e-3+ (12.0e-3-1.5e-3)*float(rbl)/((n_rbl-1)/2)
;endif else begin
; d_min(rbl)=12.0e-3
; d_max(rbl) = 1.5e-3+ (12.0e-3-1.5e-3)*float(n_rbl-rbl)/((n_rbl-1)/2)
;endelse
;rmsphase=fltarr(ndf)
;r_max=d_max(rbl)/2
;r_min=d_min(rbl)/2

r_max = d_maxx/2
r_min = d_minn/2




print, 'r_max = ', r_max
print, 'r_min = ', r_min

df = -2.0 + findgen(ndf)/float(ndf-1)*4.0
;df = -0.5 + findgen(ndf)/float(ndf-1)*1.0

amp = fltarr(ndf, nmkz, nlambda)
rmk=fltarr(nmkz) ; set up the radii of the 3 zones
rmk(2) = r_max
rmk(1) = rmk(2) / sqrt(3.0/2.0) 
rmk(0) = rmk(1) / sqrt(2.0) 
;rmk(1) = 4.0e-3
;rmk(0) = 2.0e-3



lambda_data=fltarr(10)
lambda_data(0)=450
lambda_data(1)=475
lambda_data(2)=500
lambda_data(3)=525
lambda_data(4)=550
lambda_data(5)=575
lambda_data(6)=600
lambda_data(7)=625
lambda_data(8)=650
lambda_data(9)=675

weight_data=fltarr(10)
weight_data(0)=0.05
weight_data(1)=0.1
weight_data(2)=0.2
weight_data(3)=0.6
weight_data(4)=1.0
weight_data(5)=0.8
weight_data(6)=0.6
weight_data(7)=0.3
weight_data(8)=0.1
weight_data(9)=0.05

;window, 0
;plot, lambda_data, weight_data, charsize=2, color=0, background = 255
; now actually create a function
lambda = 450.0 + 200.0*findgen(nlambda)/float(nlambda-1)

;;;; toggle  edit next line to turn of weighting
weight =  exp(-(3.0e8/lambda-5.45e5)^2 / 5e4^2)
;oplot, lambda, weight, color=100

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; how to convert from dioptres to Zernike amplitudes
; Using the famous cicle geometry theorem (ab = cd) then we get for a mirror
; f = r^2 / (2 Delta) where f = focal length, r = radius, and Delta = PV (sag)
; So, if D = dioptres then we have D = 2 delta / r^2 
; or D = 8 delta / d^2 where d is the diameter.
;
; here we have two phase defocus terms. 
; z3 comes from the spectral dependence of the eye
; and zf comes from the actual defocus.
;
; from Laura's thesis we have the following conversion from
; dioptres into zernike amplitude
; D = 4 sqrt(3) RMS / r^2, but here the units are microns (or else doesn't
; work dimensionally).
;
; hence RMS = D r^2 / (4 sqrt(3))
; we can get the same expression from above equations. The PV of a single zernike
; defocus term of sqrt(3)(2 r^2 -1) is 2 sqrt(3)
; and hence 2 sqrt(3) RMS = delta
; using D = 2 delta / r^2, or delta =  D r^2 /2
; we can say RMS = D r^2 / (4 sqrt(3)) as before
; Again, the units of RMS in the above terms are microns (or at least distance)
;
; replacing the radius with diameter gives RMS = D d^2 (16 sqrt(3))



pcoeff=1.7312
qcoeff=0.63346
ccoeff=0.2140

;  toggle the following line to set all the wavelength values to be the same
;lambda =findgen(nlambda)*0.0+550

  bu = bu_base *lambda/lambda(0)
  m3 = pcoeff - qcoeff/(lambda*1e-3 - ccoeff) + 0.13+0.0240974+4.28408e-08
 ; m3 = -1*m3; (lambda-550)/100*1.0
 ; :::::NOTE NOTE - have added on 0.13 at end so approx 0 at 550
; the z3 term is for the chromatic dependence
  z3 = 1.0/lambda*1.0e9*m3 *(d_maxx/2)^2/(4.0*sqrt(3)) ; no 2 pi
  ; there is no 2 pi because the zernike modes are defined st if the amplied 
  ; amplitude is 1 then the output has an RMS of 1 rad^2. If we wanted to
  ; produce say a wave of the mode then 

;; zf is actual defocus value.
zf = fltarr(nlambda, ndf)
for j=0,ndf-1 do begin  
 for i=0,nlambda-1 do begin  
   zf(i,j) = 1.0/lambda(i)*1.0e9*df(j) *rmk(2)^2/(4.0*sqrt(3)) ; no 2 pi
; it should be /4 in the above since it is a radius
;RMS = D r^2 / (4 sqrt(3))
 endfor
endfor

; outloop = 0 for calibration
; outloop = 1 for single lens
; outloop = 2 for mk lens
for outloop= 0, 2 do begin
loadct, 39

if outloop eq 1 then begin
 print, 'copying data'
 psf_sum_norm= psf_sum
endif
if outloop eq 2 then begin
 print, 'copying data'
 psf_sum_single= psf_sum
endif
psf_sum=fltarr(ndf,npt_base, npt_base)




 
; zmk_d is the differential defocus (in dioptres) from the MK model between the different zones.
; Assume 3 zones. Assume the central zone has "perfect" focus.  
  zmk_d=fltarr(nmkz)
  zmk=fltarr(nmkz,nlambda)
  zmk_d(0)=  0.0; 1.0*(rmk(2)/rmk(0))^2 
if outloop eq 2 then begin
   zmk_d(1)= 0.6
   zmk_d(2)=  0.3
endif

for k=0,nlambda-1 do begin
 for mk=0, 2 do begin
   zmk(mk,k) = 1.0 / lambda(k) * 1.0e9 * zmk_d(mk)   * rmk(2)^2 /(4.0*sqrt(3)) ; no 2 pi
 endfor
endfor 
 

d_max_xscale = d_maxx
xscale = (findgen(npt_base)-hnpt_base)*lambda(0)*1.0e-9 / (bu_base*d_max_xscale)*180.0/!pi*60
sf = (findgen(npt_base)-hnpt_base)*bu_base*d_max_xscale/(lambda(0)*1e-9*npt_base)*!pi/180


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Generate overall elliptical pupil

pupil = fltarr(npix,npix)
major = r_max
minor = r_min
for j=0, npix-1 do begin
 for i=0, npix-1 do begin
  x = float(i-npix/2)/(npix/2)*d_maxx/2
  y = float(j-npix/2)/(npix/2)*d_maxx/2
  ; use equations x^2 / a^2  + y^2 / b^2 = 1
  r = x^2/major^2 + y^2/minor^2 
  if r le 1.0 then pupil(i,j) = 1.0
 endfor
endfor
print, 'Total Pupil = ', total(pupil)
normalization_pupil = 1.0/sqrt(total(pupil^2))
pupil = pupil *  normalization_pupil
theta=90.0 ;+90.0*float(rbl)/float(n_rbl-1)
pupil = rot(pupil, theta)

window,0
tvscl, pupil


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; sub pupil arrays for each of the zones


sub_pupil = fltarr(nmkz, npix,npix)

for mz=0, nmkz-1 do begin
 radius = rmk(mz) / (d_maxx/2)
 for j=0, npix-1 do begin
  for i=0, npix-1 do begin
   x = float(i-npix/2)/(npix/2)
   y = float(j-npix/2)/(npix/2)
   r = sqrt( x^2 + y^2)
   if r le radius then sub_pupil(mz,i,j) = 1.0
  endfor
 endfor
endfor


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; generate zernike modes and phase map
;

phase=fltarr(npix,npix)

; Convert Zernike index into quantum numbers
for nz=1,nzerns-1 do begin
  csum=fltarr(nz+1)
  for i=1,nz do begin
    csum(i) = total(indgen(i)+1)
  endfor
  nindx = fix(total(csum lt nz))
  mx = csum(nindx-1)
  n=nindx-1
  m = nz - mx - 1;
  if float(n-m)/2 eq round(n-m)/2 then begin
    even = 1
  endif else begin
    even = 0
    m = m + 1
  endelse
  phase = phase + 2*!pi*amp_zern(nz)*zern_gen(npix,n,m,even)
endfor
;;;; Here the Zernikes are defined st their rms error is 1 radian for 1 unit of
;;;; applied amplitude


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Generate padded wavefront


for dfloop = 0, ndf-1 do begin
;print, 'defocus  ', df(dfloop), '   Outer Loop = ', outloop

for k=0,nlambda-1 do begin
 npt =floor(npix*bu(k))
 hnpt = floor(npt/2)
complex_pupil = complexarr(2,nmkz,npt, npt)
complex_image = complexarr(2,nmkz,npt, npt)
 big_pupil = fltarr(nmkz,npt, npt)
 big_phase = fltarr(2,nmkz,npt, npt)

count = fltarr(nmkz)
 for mz=0, nmkz-1 do begin ; loop over the mk zones
   big_pupil(mz,hnpt-npix/2:hnpt+npix/2-1,hnpt-npix/2:hnpt+npix/2-1) = pupil*sub_pupil(mz,*,*)
   amp(dfloop,mz,k) = (z3(k)+zf(k,dfloop)+zmk(mz,k))
   
    if abs(amp(dfloop,mz,k)) le 30.0 then begin
     count(mz) = 1.0
    endif else begin
      count(mz) = 0.0
    endelse
 
;if lambda(k) eq 550 then print, 'amp = ', amp(dfloop,mz,k), '    lambda = ',lambda(k), '   loop', dfloop, '  out of', ndf, '    outer loop = ', outloop
    
 
       
   big_phase(0,mz,hnpt-npix/2:hnpt+npix/2-1,hnpt-npix/2:hnpt+npix/2-1) = phase*amp(dfloop,mz,k)
  
   if mz lt 2 then begin
     big_phase(1,mz,hnpt-npix/2:hnpt+npix/2-1,hnpt-npix/2:hnpt+npix/2-1) = phase*(z3(k)+zf(k,dfloop)+zmk(mz+1,k))
   endif


   if outloop eq 0 then begin 
    big_phase(0,mz,hnpt-npix/2:hnpt+npix/2-1,hnpt-npix/2:hnpt+npix/2-1) = phase*0.0
    big_phase(1,mz,hnpt-npix/2:hnpt+npix/2-1,hnpt-npix/2:hnpt+npix/2-1) = phase*0.0
    dfloop = ndf-1
   endif
 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;; Calculate Diffraction Pattern
ch  = checker(npt)
for rings =0,1 do begin
 complex_pupil(rings,mz,*,*) = big_pupil(mz,*,*)*exp(complex(0.0, big_phase(rings,mz,*,*)+ch))
 complex_image(rings,mz,*,*) = fft(complex_pupil(rings,mz,*,*), -1)*float(npt)
endfor
endfor ; end of loop over mk zones

 
final_complex_image = fltarr(npt, npt)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; now add together different amplitude spread functions
final_complex_image = final_complex_image $
+ complex_image(0,2,*,*) - complex_image(1,1,*,*)$
+ complex_image(0,1,*,*) - complex_image(1,0,*,*)$
+ complex_image(0,0,*,*) 

psf = (abs(final_complex_image))^2

add = total(count) gt 0
if outloop eq 0 then add = 1.0
psf_sum(dfloop,*,*) = psf_sum(dfloop,*,*)+add*weight(k)*psf(hnpt-hnpt_base:hnpt+hnpt_base-1,hnpt-hnpt_base:hnpt+hnpt_base-1)


endfor ; end of loop over wavelength


;;;;;;;;; toggle make next line active if you want to normalize slice by slice
; psf_sum(dfloop,*,*) = psf_sum(dfloop,*,*)  / max(psf_sum(dfloop,*,*))


ch  = checker(npt_base)
if max(psf_sum) gt 0 then begin
 mtf(dfloop,*,*) = abs(fft(psf_sum(dfloop,*,*)*exp(complex(0.0,ch)),-1))
 mtf(dfloop,*,*) = mtf(dfloop,*,*)/max(mtf(dfloop,*,*))
endif

endfor ; end loop over defocus values

if outloop ne 0 then begin
for k=0, ndf- 1 do begin
  window, 0, xsize = npt_base, ysize = npt_base
  tvscl, psf_sum(k,*,*)
  eeee(outloop,k) =en_en(psf_sum(k,*,*))
  print, k, eeee(outloop,k)
 endfor
 endif


 
 
xp = 32
blpsf = 2; psf blow up factor
blmtf = 2 ;8; psf blow up factor
bl = 5; blow up for defocus axis
rangepsf= 120 ; npix ;;;32
rangemtf=32


plpsfh = psf_sum(*,hnpt_base,hnpt_base-rangepsf:hnpt_base+rangepsf-1)
plmtfh = mtf(*,hnpt_base,hnpt_base-rangemtf:hnpt_base+rangemtf-1)
plpsfv = psf_sum(*,hnpt_base-rangepsf:hnpt_base+rangepsf-1,hnpt_base)
plmtfv = mtf(*,hnpt_base-rangemtf:hnpt_base+rangemtf-1,hnpt_base)
plsf = (findgen((2*rangemtf)*blmtf)-rangemtf*blmtf)*bu_base*d_max_xscale/(lambda(0)*1e-9*npt_base)*!pi/180/blmtf
plxscale = (findgen((2*rangepsf)*blpsf)-rangepsf*blpsf)*lambda(0)*1.0e-9 / (bu_base*d_max_xscale)*180.0/!pi*60/blpsf

window, 0, xsize = ndf*bl, ysize = (2*rangepsf)*blpsf, retain = 2
tv, rebin(plpsfh,ndf*bl, 1, (2*rangepsf)*blpsf)
pldf = min(df)+ findgen(ndf*bl)/float(ndf*bl-1) * (max(df)-min(df))

 output = tvrd(true=1)
 redpsfh    = fltarr(ndf*bl,(2*rangepsf)*blpsf)
 greenpsfh  = fltarr(ndf*bl,(2*rangepsf)*blpsf)
 bluepsfh   = fltarr(ndf*bl,(2*rangepsf)*blpsf)
 for j=0, (2*rangepsf)*blpsf-1 do begin
  for i = 0, ndf*bl-1 do begin
   redpsfh(i,j) = output(0,i,j)
   greenpsfh(i,j) = output(1,i,j)
   bluepsfh(i,j) = output(2,i,j)
  endfor
 endfor

window, 1, xsize = ndf*bl, ysize = (2*rangepsf)*blpsf, retain = 2
tv, rebin(plpsfv,ndf*bl, (2*rangepsf)*blpsf)


 output = tvrd(true=1)
 redpsfv    = fltarr(ndf*bl,(2*rangepsf)*blpsf)
 greenpsfv  = fltarr(ndf*bl,(2*rangepsf)*blpsf)
 bluepsfv   = fltarr(ndf*bl,(2*rangepsf)*blpsf)
 for j=0, (2*rangepsf)*blpsf-1 do begin
  for i = 0, ndf*bl-1 do begin
   redpsfv(i,j) = output(0,i,j)
   greenpsfv(i,j) = output(1,i,j)
   bluepsfv(i,j) = output(2,i,j)
  endfor
 endfor

window, 2, xsize = ndf*bl, ysize =(2*rangemtf)*blmtf, retain=2
tvscl, rebin(plmtfh,ndf*bl,1,(2*rangemtf)*blmtf)


 output = tvrd(true=1)
 redmtfh    = fltarr(ndf*bl,(2*rangemtf)*blmtf)
 greenmtfh  = fltarr(ndf*bl,(2*rangemtf)*blmtf)
 bluemtfh   = fltarr(ndf*bl,(2*rangemtf)*blmtf)
 for j=0, (2*rangemtf)*blmtf-1 do begin
  for i = 0, ndf*bl-1 do begin   
   redmtfh(i,j) = output(0,i,j)
   greenmtfh(i,j) = output(1,i,j)
   bluemtfh(i,j) = output(2,i,j)
  endfor
 endfor


window, 3, xsize = ndf*bl, ysize =(2*rangemtf)*blmtf, retain=2
tvscl, rebin(plmtfv,ndf*bl,(2*rangemtf)*blmtf)

 output = tvrd(true=1)
 redmtfv    = fltarr(ndf*bl,(2*rangemtf)*blmtf)
 greenmtfv  = fltarr(ndf*bl,(2*rangemtf)*blmtf)
 bluemtfv   = fltarr(ndf*bl,(2*rangemtf)*blmtf)
 for j=0, (2*rangemtf)*blmtf-1 do begin
  for i = 0, ndf*bl-1 do begin   
   redmtfv(i,j) = output(0,i,j)
   greenmtfv(i,j) = output(1,i,j)
   bluemtfv(i,j) = output(2,i,j)
  endfor
 endfor


rbl=1
if outloop eq 1 then begin
 fn='psf_zone2'+string(rbl)+'.dat'
 openw, 1,fn
 writeu, 1, psf_sum
 close, 1
endif
if outloop eq 2 then begin
 fn='psf_zone'+string(rbl)+'.dat'
 openw, 1,fn
 writeu, 1, psf_sum
 close, 1
endif

set_plot, 'PS'
loadct, 0
if outloop eq 1 then begin
 fn='slice_zone2'+string(rbl)+'.eps'
 DEVICE, /helvetica, FILENAME=fn, /COLOR, /ENCAPSULATED, bits=8
endif
if outloop eq 2 then begin
 fn='slice_zone'+string(rbl)+'.eps'
 DEVICE, /helvetica, FILENAME=fn, /COLOR, /ENCAPSULATED, bits=8
endif

th = 3
cs=1.5
disp3, redpsfh,greenpsfh,bluepsfh, pldf,  plxscale, charsize = 1, pos = [0.15,0.15,0.48,0.5]
disp3, redpsfv,greenpsfv,bluepsfv, pldf,  plxscale, charsize = 1, pos = [0.15,0.6,0.48,0.95], /noerase


;disp3, redmtfh,greenmtfh,bluemtfh, pldf, plsf, charsize = 1, pos = [0.65,0.15,0.98,0.5], /noerase
; xyouts, 9000, 11000, '(c)', color=0, charsize=1, charthick=th, /device

;disp3, redmtfv,greenmtfv,bluemtfv, pldf, plsf, charsize = 1, pos = [0.65,0.6,0.98,0.95], /noerase
; xyouts, 9000, 5000, '(d)', color=0, charsize=1, charthick=th, /device


 

  ;;; need to run slit_real_data first to get the data below
; if rbl eq 0 then  tv, data1, /device, true=1,10000,0
; if rbl eq 1 then  tv, data2, /device, true=1,10000,0
; if rbl eq 2 then  tv, data3, /device, true=1,10000,0
; if rbl eq 3 then  tv, data4, /device, true=1,10000,0
; if rbl eq 4 then  tv, data5, /device, true=1,10000,0
; if rbl eq 5 then  tv, data6, /device, true=1,10000,0
; if rbl eq 6 then  tv, data7, /device, true=1,10000,0
; if rbl eq 7 then  tv, data8, /device, true=1,10000,0
; if rbl eq 8 then  tv, data9, /device, true=1,10000,0
; if rbl eq 9 then  tv, data10, /device, true=1,10000,0
; if rbl eq 10 then  tv, data11, /device, true=1,10000,0
; if rbl eq 11 then  tv, data12, /device, true=1,10000,0
; if rbl eq 12 then  tv, data13, /device, true=1,10000,0
; if rbl eq 13 then  tv, data14, /device, true=1,10000,0
; if rbl eq 14 then  tv, data15, /device, true=1,10000,0
; if rbl eq 15 then  tv, data16, /device, true=1,10000,0
; if rbl eq 16 then  tv, data17, /device, true=1,10000,0
; if rbl eq 17 then  tv, data18, /device, true=1,10000,0
; if rbl eq 18 then  tv, data19, /device, true=1,10000,0
 

; tvscl, max(pupil) - pupil , 8700,6000, xsize=1000
; xyouts, 500, 1600, '(e)', color=0, charsize=1, charthick=th, /device
 
 ;;;;;
; generate artifical eye
eye_size=128
 eye = fltarr(eye_size,eye_size)
 outer = 20.0
 major = 12.0
 minor = 1.5
 for j=0, eye_size-1 do begin
  for i=0, eye_size-1 do begin
   x = float(i-eye_size/2)/(eye_size/2)*outer
   y = float(j-eye_size/2)/(eye_size/2)*outer
   ; use equations x^2 / a^2  + y^2 / b^2 = 1
   r1 = sqrt(x^2 + y^2)
   if r1 le outer-2 then eye(i,j) = 255-170
   r = x^2/major^2 + y^2/minor^2 
   if r le 1 then eye(i,j) = 255.0
  endfor
endfor

eye = rot(eye, theta)
eye  = 255-eye


 eye(0:eye_size-1,0) = 0
 eye(0:eye_size-1,1) = 0
 eye(0:eye_size-1,eye_size-1) = 0
 eye(0:eye_size-1,eye_size-2) = 0
 eye(0,0:eye_size-1) = 0
 eye(0,1:eye_size-1) = 0
 eye(eye_size-1,0:eye_size-1) = 0
 eye(eye_size-2,0:eye_size-1) = 0
 
 
 loadct, 1
 tv,eye , 7750,5700, xsize=3000 
 loadct,1 
 
 th=5
 xyouts, 3000, 11500, 'A', color=255, charsize=cs, charthick=th, /device
 xyouts, 3000, 5700, 'B', color=255, charsize=cs, charthick=th, /device
 xyouts, 2500, 400, 'Dioptric Difference (D)', color=0, charsize=cs, charthick=th, /device
 xyouts, 1500, 4500, 'Angle (arcmin)', color=0, charsize=cs, charthick=th, orientation = 90, /device 
 ;xyouts, 10300, 4000, 'Spatial Frequency (cycles/degree)', color=0, charsize=1, charthick=th, orientation = 90, /device
 xyouts, 10500, 12000, 'C', color=255, charsize=cs, charthick=th, /device
 xyouts, 7850, 8100, 'D', color=0, charsize=cs, charthick=th, /device
 
  
DEVICE, /CLOSE
SET_PLOT, 'X'



endfor; endouterloop


;endfor ; end really big loop




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Need this next bit if you want to read data back in from file
;psf_sum_single =fltarr(101, 256, 256)
;openu, 1, 'psf_single_circ.dat'
; readu,1, psf_sum_single
;close, 1
;psf_sum =fltarr(101, 256, 256)
;openu, 1, 'psf_zone_circ.dat'
; readu,1, psf_sum
;close, 1
  
jump: dummy=0
  
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; This next bit plots the strehl as a function of dioptre

;norm_strehl = max(psf_sum_norm)
;psf_sum = psf_sum / norm_strehl
;psf_sum_single = psf_sum_single / norm_strehl
;strehl_single = fltarr(ndf)
;strehl_zone = fltarr(ndf)
;for k=0, ndf-1 do begin
; strehl_single(k)= psf_sum_single(k, hnpt_base, hnpt_base)
; strehl_zone(k)= psf_sum(k, hnpt_base, hnpt_base)
;endfor
;SET_PLOT, 'PS'
;DEVICE, FILENAME='strehl_circ.eps', /COLOR, /ENCAPSULATED
;;window, 1
;plot, df, strehl_single, color = 0, background =255, $
;xtitle = 'Focal Position (Diopters)', ytitle = 'Strehl ratio'
;oplot, df, strehl_zone, color =200
;DEVICE, /CLOSE
;SET_PLOT, 'X'
;write_csv, 'strehl_single_slit.csv', df, strehl_single
;write_csv, 'strehl_zone_slit.csv', df, strehl_zone


eeee_scale = eeee
eeee_scale = eeee * lambda(0)*1e-9 / (bu_base * d_max_xscale) * 180 / !pi *60
window, 1
plot, df, eeee_scale(1,*), background = 255, color = 0
oplot, df , eeee_scale(2,*), color = 200


print, 'hello'

end
  
