set terminal postscript portrait color enhanced  "Times-Roman, 19"

set output "SuperballisticWeissEtAl2015Fig6.ps"

set size 1.2,0.5



set origin 0.00,1.2

set xtics font "Times-Roman"

set ytics font "Times-Roman"

set ylabel "{/Times-Italic  N , (N_0-N)}"

set xlabel "{/Times-Italic t}  {/Times (s)}"


set nokey


set label "{/Times (a)}" at 0.0007,1000

set format x "10^{%T}"
set format y "10^{%T}"
set logscale y

set logscale x
set xtics 0.0000001, 10, 10000





unset label



set ylabel "{/Times-Italic  {/Symbol x / x_{N_0}}}"



set nolabel


set ylabel " {/Symbol D}{/Times-Italic x} / {/Symbol x_{/Times-Italic N_0}}"
set logscale x
set logscale y


unset label

set label "{/Times (b)}" at 0.0007,80

                
unset label

set origin 0.0, 0.6

plot[0.1:100][1.0:100]  0.45*x with lines lt 4 lw 3 lc rgb "green", "paperballdiffRbN20.dat" u  6:5 with lines lw 9  lt 1 lc rgb "red", 0.15*x**(1.5) with lines lt 5 lw 3 lc rgb "black", ((.4424315072*x+0.5081124609e-2*x**3+.1491598799*x**2+2.500000001)**(0.5)) with lines lt 1 lw 3 lc rgb "#00FFFF"
