set terminal postscript portrait color enhanced  "Times-Roman, 19"

set output "SuperballisticWeissEtAl2015Fig4.ps"


set size 1.2,0.8
set multiplot


set size 1.2,0.4



set origin 0.0,0.0

set xtics font "Times-Roman"

set ytics font "Times-Roman"


set ylabel " {/Symbol D}{/Times-Italic x} / {/Symbol x_{/Times-Italic N_0}}"
set xlabel "{/Times-Italic t}  {/Times (s)}"


set nokey

set format x "10^{%T}"
set format y "10^{%T}"
set logscale y

set logscale x
set xtics 0.0000001, 10, 100
#set ytics 0.01, 10, 10000





plot[0.001:100][1:10000] "paperballdiffRb3000.dat" u  6:5 with lines lw 10 lt 1 lc rgb "blue", "balldiffRb4000.dat" u  6:5 with lines lw 10 lt 2 lc rgb "red", ((2041.068028*x+.3850084091*x**3+.3674872037*x**2+0.1666666667e-1)**(0.5)) with lines lw 3  lt 1 lc rgb "#00FFFF", ((6483.570665*x+2.174949931*x**3+.8713712741*x**2+0.1250000000e-1)**(0.5)) with lines lw 3  lt 1 lc rgb "#00FFFF", 2*x with lines lt 4 lw  3 lc rgb "green", 2*x**(1.5) with lines lt 5 lw  3 lc rgb "black"

set ylabel "{/Times-Italic N(t)}"


set origin 0.0, 0.4

plot[0.001:100][1:10000]  "balldiffRb3000.dat" u  6:((3000.0-($2))) with lines lw 6  lt 1 lc rgb "blue", "balldiffRb3000.dat" u  6:2 with lines lw 3  lt 1 lc rgb "blue", "balldiffRb4000.dat" u  6:((4000.0-($2))) with lines lw 6  lt 2 lc rgb "red", "balldiffRb4000.dat" u  6:2 with lines lw 3  lt 2 lc rgb "red"