set terminal postscript portrait color enhanced  "Times-Roman, 19"

set output "SuperballisticWeissEtAl2015FigNew3.ps"

set size 1.2,1.5

set multiplot

set size 1.2,0.5


#set size 1.23,0.3



set origin 0.00,1.0

set xtics font "Times-Roman"

set ytics font "Times-Roman"

set xlabel "{/Times-Italic t}  {/Times (s)}"


set nokey



set format x "10^{%T}"
set format y "10^{%T}"
set logscale y

set logscale x
set xtics 0.0000001, 10, 10000
#set ytics 0.01, 10, 10000





#unset label




#set nolabel

set label "(a)" at 0.005, 100.0 front textcolor rgb "black"


set ylabel " {/Symbol D}{/Times-Italic x} / {/Symbol x_{/Times-Italic N_0}}"
set logscale x
set logscale y



plot[0.001:10][0.1:1000]  "paperballdiffLiCWYC12WithSingle.dat" u  6:5 with lines lw 9  lt 4 lc rgb "brown", 30*x with lines lt 4 lw 3 lc rgb "green",  ((16.44934067*x+1737.435098*x**3+6859.118837*x**2+.5000000002)**(0.5)) with lines lt 1 lw 3 lc rgb "#00FFFF", "paperballdiffLiCWYC12WithSingle2.dat" u  6:5 with lines lw 9  lt 1 lc rgb "red", 30*x**(1.5) with lines lt 5 lw 3 lc rgb "black", ((16.44934067*x+1737.435098*x**3+1097.459014*x**2+3.125000001)**(0.5)) with lines lt 1 lw 3 lc rgb "#00FFFF"



set palette rgbformulae 30,31,32

set nokey

set pm3d map

set origin -0.00,0.55

unset label

unset logscale y

unset format

set logscale x

set format x "10^{%L}"

set ytics -20,10,20

set xtics 0.0001, 10, 10000

set xlabel "{/Times } {/Times-Italic  t   }{/Times  (s) }"

set ylabel " {/Times-Italic  x / {/Symbol x}_{N_0} }"
 
#set label "(a)" at -8, 0.4 front textcolor rgb "white"

#set logscale y

unset label

set label "(b)" at 0.02, 10.0 front textcolor rgb "white"

splot[0.01:1.0][-20:20][0.000000:1]  "BALLDIFFSPD.DAT" u 1:2:3 

set origin 0.15,0.005

set nolabel

set ytics 0.0001, 10, 10000

set logscale y



set format y "10^{%L}"

set label "(c)" at 0.2, 3000.0 front textcolor rgb "white"

set xlabel "{/Times } {/Times-Italic  t^2   }{/Times  (s^2) }"


set ylabel " ({/Times-Italic  x / {/Symbol x}_{N_0}})^2" offset -2,0
 

set size 0.9,0.6


splot[0.1:10][100.0:10000][0.000000:1]  "BALLDIFFSPDNORM.DAT" u (($1)**2):(($2)**2):3
