set terminal postscript portrait color enhanced  "Times-Roman, 19"

set output "SuperballisticWeissEtAl2015Fig2.ps"

set size 1.2,0.5



set origin 0.00,0.0

set xtics font "Times-Roman"

set ytics font "Times-Roman"


set ylabel " {/Symbol D}{/Times-Italic x} / {/Symbol x_{/Times-Italic N_0}}"
set xlabel "{/Times-Italic t}  {/Times (s)}"


set nokey

set origin 0, 0.4




set format x "10^{%T}"
set format y "10^{%T}"
set logscale y

set logscale x
set xtics 0.0000001, 10, 100
#set ytics 0.01, 10, 10000

set origin 0, 0.0

plot[0.0001:100][0.1:10000]   "balldiffPRALiENS12.dat" u  6:5 with lines lw 10 lc rgb "blue", "balldiffPRALiENS8.dat" u  6:5 with lines lw 10 lt 1 lc rgb "brown", "balldiffPRALiENS9.dat" u  6:5 with lines lw 10 lt 1 lc  rgb "red", "balldiffPRALiENS9.dat" u  6:5 with lines lw 10 lt 1 lc  rgb "red", ((598.0478126*x+25.16517803*x**3+163.9545914*x**2+0.8333333330e-2)**(0.5)) with lines lw 3  lt 1 lc rgb "#00FFFF", ((69.99301338*x+1.308553487*x**3+48.56294449*x**2+0.1250000000e-1)**(0.5)) with lines lw 3  lt 1 lc rgb  "#00FFFF",  ((3337.860801*x+97.52409174*x**3+94.86847708*x**2+0.1000000000e-1)**(0.5)) with lines lw 3  lt 1 lc rgb  "#00FFFF", 7.1*x with lines lw 4 lt 4 lc rgb "green", 3.1*x**(1.5) with lines lw 4 lt 5 lc rgb "black"
