clear all
set(0,'defaulttextinterpreter','latex')

fontsizevalue = 10;
NP = 6401;
L = 40;
B = 40/(NP-1);
NDAT = 201;

hbar = 1.054571726*10^(-34);
u = 1.660539040*10^(-27);
omega = 2*pi*5; 
mLi = 7*u;


datawpN1 = load('Fig3a.dat');
    
L1 = sqrt(hbar/(1*mLi*omega));
B = 40*L1/(NP-1);
ort = [-20*L1:B:20*L1]*10^6;
T = 2*pi/omega;
zeit = [0:T/(NDAT-1):T]*1000;
 
figure1 = figure(1);

axes('Position',[0.2 0.7 0.25 0.2])
xs = [-30:0.025:30]*10^(-6);
Omhlp = 4*1*mLi*omega*30*10^(-6)/hbar;
T = 0.5*(1+cos(xs*Omhlp));
plot(xs*10^6,T,'k','LineWidth',1)
hold on
plot(datawpN1(:,2)*L1*10^6,datawpN1(:,4),'--r','LineWidth',1)

set(gca,'XLim',[-15 15],'XTick',[-15,-7.5,0.0,7.5,15],'XTickLabel',{'-15','','0','','15'},'YTick',[0,0.5,1],'FontSize', fontsizevalue)
xlabel('$x_{\rm{s}} [\mu m]$', 'FontSize', fontsizevalue)
ylabel('$T$', 'FontSize', fontsizevalue)
text(-13,0.9,'(a)','FontSize', fontsizevalue)



axes('Position',[0.2 0.4 0.25 0.2])
Omhlp2 = 4*100*mLi*omega*30*10^(-6)/hbar;

datanew = load('DataN100Noninteracting.dat');
fac = 2*pi*10^(6)/Omhlp;
plot(datanew(:,1)*fac,datanew(:,2),'k','LineWidth',1)
hold on
plot(datanew(:,1)*fac,datanew(:,3),'-.g','LineWidth',1)
hold on
plot(datanew(:,1)*fac,datanew(:,4),'--r','LineWidth',1)
text(-13,0.9,'(b)','FontSize', fontsizevalue)

set(gca,'XLim',[-15 15],'XTick',[-15,-7.5,0.0,7.5,15],'XTickLabel',{'-15','','0','','15'},'YTick',[0,0.5,1],'FontSize', fontsizevalue)
xlabel('$X_{\rm{s}} [\mu m]$', 'FontSize', fontsizevalue)
ylabel('$T$', 'FontSize', fontsizevalue)

L1 = sqrt(hbar/(100*mLi*omega));



datawpN100 = load('Fig3cdelta.dat');
datawpc0_5 = load('Fig3c_cosh0_5.dat');

axes('Position',[0.2 0.1 0.25 0.2])
xs = [-0.3:0.001:0.3]*10^(-6);
T = 0.5*(1+cos(xs*Omhlp2));
plot(xs*10^6,T,'k','LineWidth',1)
hold on
plot(datawpN100(:,2)*L1*10^6,datawpN100(:,4),'-.g','LineWidth',1)
hold on
plot(datawpc0_5(:,2)*L1*10^6,datawpc0_5(:,4),'--r','LineWidth',1)




set(gca,'XLim',[-0.15 0.15],'XTick',[-0.15,-0.075,0.0,0.075,0.15],'XTickLabel',{'-0.15','','0.0','','0.15'},'YTick',[0,0.5,1],'FontSize', fontsizevalue)
xlabel('$X_{\rm{s}} [\mu m]$', 'FontSize', fontsizevalue)
ylabel('$T$', 'FontSize', fontsizevalue)
text(-0.13,0.9,'(c)','FontSize', fontsizevalue)
% Create line

annotation(figure1,'line',[0.44140625 0.33203125],...
    [0.3046875 0.394833333333333 ],'LineStyle','-.');

% Create line
annotation(figure1,'line',[0.208984375 0.3125],...
    [0.3046875 0.394833333333333],'LineStyle','-.');


print -depsc2 Fig3.eps

