% compute imagesc plot
set(0,'defaulttextinterpreter','latex')
fsv = 8;

hbar = 1.054571726*10^(-34);
u = 1.660539040*10^(-27);
omega = 2*pi*5; 
mLi = 7*u;

L1 = sqrt(hbar/(100*mLi*omega));

data = load('Fig2a.dat');


xs = data(1:33,2);
xs = [-flipud(xs);xs(2:end)];
axes1 = axes('Position',[0.2 0.52 0.25 0.25])
ell = 0.5*[0.0:0.025:0.625]*L1*10^6;
datamat = reshape(data(:,4),33,26);
datamatfull = [flipud(datamat);datamat(2:end,:)];
cbarmax = max(max(datamatfull))
imagesc(xs,ell,datamatfull',[0 cbarmax])
xlabel('$X_s [\mu m]$','FontSize',fsv)
ylabel('$\xi_N [\mu m]$','FontSize',fsv)
load('inversemap.mat');
colormap(inversemap)
cbar = colorbar('Location','EastOutside','YTick',[0.0 0.5 0.998]);
zlab = get(cbar,'ylabel');
set(zlab,'String','$T$');

set(cbar,'Position',[0.46 0.52 0.015 0.25])
set(gca,'YLim',[0.0 0.5],'YDir','Norm','XTick',[-0.15,-0.075,0,0.075,0.15],'YTick',[0.0,0.125,0.25,0.375,0.5], ...
    'XTickLabel',{'-0.15','','0.0','','0.15'},'YTickLabel',{'0.0','','0.25','','0.5'},'FontSize',fsv)
text(-0.148,0.48,'(a)', 'FontSize', fsv)

axes('Position',[0.2 0.2 0.25 0.25])

data = load('Fig2b.dat');

xs = data(1:33,2);
xs = [-flipud(xs);xs(2:end)];


%x0 = [1:1:9];
x0 = [17.6535*1*L1*10^6:-0.5*1.76535*L1*10^6:0.8827*L1*10^6];
datamat = reshape(data(:,4),33,20);
%
datamatfull = [flipud(datamat);datamat(2:end,:)];
cbarmax = max(max(datamatfull))
cbarmin = min(min(datamatfull))
imagesc(xs,x0,datamatfull',[0.0 cbarmax])
xlabel('$X_s [\mu m]$','FontSize',fsv)
ylabel('$X_0 [\mu m]$','FontSize',fsv)
cbar = colorbar('Location','EastOutside','YTick',[cbarmin 0.45 0.891],'YTickLabel',{'0.0','0.45','0.891'});
%cbar = colorbar('Location','EastOutside','YTick',[0.0 0.35 0.689]);
zlab = get(cbar,'ylabel');
set(zlab,'String','$T$');
set(cbar,'Position',[0.46 0.2 0.015 0.25])
set(gca,'YLim',[3 30],'YDir','Norm','XTick',[-0.15,-0.075, 0,0.075,0.15 ],'YTick',[3,16.5,30], ...
   'XTickLabel',{'-0.15','','0.0','','0.15'},'YTickLabel',{'3.0','16.5','30.0'},'FontSize',fsv)
text(-0.148,29,'(b)', 'FontSize', fsv)


print -depsc Fig2.eps
