function createfigure(X1, Y1)
%%
%Fixed parameters:
  Lc = 50e-3; %crystal length in metres
  pp1 = 13.45e-6; %crystal poling period in metres - channel 1 from RHS
  pp2 = 13.35e-6; %crystal poling period in metres - channel 2 from RHS
  pp3 = 13.25e-6; %crystal poling period in metres - channel 3 from RHS
  pp4 = 13.15e-6; %crystal poling period in metres - channel 4 from RHS
  pp5 = 13.05e-6; %crystal poling period in metres - channel 5 from RHS
  
%%
% Adjust the relavent parameters here:

  %Define maximum and minium temperatures (used for plot)
  Tmin=123;
  Tmax=129;
  
  %Set the wavelengths you are using:
  L1 = 1557.4e-9; %1550 wavelength in meters
  L2 = 1079e-9;  %1079 wavelength in meters
  L3 = 1/(1/L1 + 1/L2);  %638 wavelength in meters
  
  %Choose which crystal channel you are using (numbered from the right-hand side)
  pp = pp2; %choose which crystal channel you are using here:

  
%% Work out the refractive index 
  %Coefficients for working out the refractive index for PPSLT:
  %[Equation and fits taken from A. Bruner et al. Optics Letters 28 (3) 194 (2003)]
  
  %LT coefficients:
  a = 4.502483;
  b = 0.007294;
  c1 = 0.185087;
  d1 = -0.02357;
  e1 = 0.073423;
  f = 0.199595;
  g = 0.001;
  h = 7.99724;
  b2 = @(T) (3.483933e-8).*(T + 273.15).^2;
  c2 = @(T) (1.607839e-8).*(T + 273.15).^2;
  
  %Refractive index:
  %(wavelengths need to be in micrometers and temperature in degrees C)
  ne = @(T,L) sqrt(a + (b + b2(T))/((L.*1e6).^2 - (c1 + c2(T)).^2) + e1/((L.*1e6).^2 - f.^2) + g/((L.*1e6).^2 - h.^2) + d1.*(L.*1e6).^2);
  
%% Work out the thermal expansion  
  %Thermal expansion (numbers from Kim et al. Journal of Applied Physics 40, 4637 (1969))
  alpha=1.6e-5;
  beta=7e-9;
  ppt = @(T) pp.*(1+alpha.*(T-25)+beta.*(T-25).^2);
  
%% Work out the phase mismatch and conversion efficiency
  %Phase mismatch:
  K = @(T) 2.*pi.*(ne(T,L3)./L3 - ne(T,L2)./L2 - ne(T,L1)./L1 - 1./ppt(T));
  
  %Relative conversion efficiency:
  eff = @(T) sin(K(T).*Lc./2).*sin(K(T).*Lc./2)./(K(T).*Lc./2)./(K(T).*Lc./2);

%%
  %Make therory fit the data by scaling the amplitude and adding temperature offset.
  eta = 0.53; %Normalised conversion efficiency
  dT = 0.55; %Adjust the temperature offset to overlap with the data.
  Eff = @(T) eff(T+dT).*eta;


%%
  %Plot
  
set(0,'defaulttextinterpreter','tex')
fontname = 'Times New Roman'; 
set(0,'DefaultTextFontname',fontname)
set(0,'DefaultAxesFontName',fontname)
set(0,'DefaultAxesFontSize',8)
set(0,'DefaultTextFontSize',8)
set(0,'defaultLineLineWidth',1);
set(0,'defaultAxesLineWidth',1);
  
%Create figure
%figure('Units','centimeters','Position',[x_pos y_pos fig_width fig_height]);
figure1 = figure('Units', 'centimeters','Position',[8 8 7 5.6]);
 
  
%Create axes
axes1 = axes('Parent',figure1,'YTick',[0 0.2 0.4 0.6]);
xlim(axes1,[Tmin Tmax]);
ylim(axes1,[-0.02 0.6]);
box(axes1,'on');
hold(axes1,'all');

%Plot prediction
fplot(Eff,[Tmin,Tmax],'--k');

% Create xlabel
xlabel('Crystal temperature ({\circ}C)');

% Create ylabel
ylabel('\eta (% W^{-1} cm^{-1})');

